# Chapter 2: Two Traditions, One Conclusion

*"Cypherpunks write code."*

Eric Hughes^1^

## Introduction

Two intellectual traditions, developed independently and for different purposes, arrived at compatible conclusions about privacy's importance. Austrian economists, working from logical analysis of human action, established that privacy is inherent to purposeful behavior. Cypherpunks, working from cryptographic implementation, demonstrated that privacy could be technically achieved. Neither tradition knew the other would reach convergent conclusions. Their convergence is not coincidental.

The Austrian tradition proceeds through deductive reasoning from self-evident axioms. Beginning with Carl Menger's methodological individualism and extending through Ludwig von Mises's praxeology to Murray Rothbard's political theory and Hans-Hermann Hoppe's argumentation ethics, this tradition derives conclusions about human action, property, and coordination through pure logic. The conclusions are a priori: they do not depend on empirical observation and cannot be falsified by experience.

The cypherpunk tradition proceeds through engineering and experimentation. Beginning with David Chaum's cryptographic innovations and extending through Timothy May's political predictions to Eric Hughes's ethical framework, this tradition builds systems that actually work. The conclusions are empirical: they depend on what functions and can be revised through implementation failure.

These methods complement each other. Austrian theory identifies what voluntary coordination requires; cypherpunk practice discovers how to provide it. This chapter examines both traditions and explains their convergence.

## 2.1 The Austrian Approach: Deduction from Action

### Carl Menger and Methodological Individualism

The Austrian School began with Carl Menger's 1871 *Principles of Economics*. Against the prevailing historical school, which sought economic laws through induction from historical data, Menger insisted that economics must begin from the individual human actor.

Methodological individualism holds that all social phenomena reduce to individual choices and actions. No collective mind exists, no social will, no group consciousness that acts independently of the individuals composing it. When we speak of "the market deciding" or "society choosing," we use shorthand for the aggregated results of individual decisions. Rigorous analysis must trace these collective outcomes back to individual actions.

This methodological commitment shapes all subsequent analysis. It means economic analysis begins with what individuals do and why, not with statistical aggregates or historical patterns. It means explanations must be causal, tracing effects to acting causes instead of correlating variables. And it means that value is subjective: goods have value because individuals value them, not because of any inherent property.

Menger also developed the theory of spontaneous order. Complex coordination, including money, language, and markets, emerges through individual interaction without central design. No one invented money; it emerged as traders converged on the most saleable commodity. No committee designed market prices; they emerge from countless individual exchanges. Order without a designer: this insight distinguishes Austrian from interventionist economics.

### Ludwig von Mises and Praxeology

Mises transformed Menger's insights into a systematic methodology he called praxeology: the science of human action. His 1949 treatise *Human Action* remains the definitive statement of Austrian method.

The foundation is the action axiom: human action is purposeful behavior. This is not an empirical generalization but a self-evident truth; any attempt to deny it refutes itself, as the denial is itself purposeful behavior. From this axiom, Mises derived the entire structure of economic theory through rigorous deduction. Chapter 3 develops the action axiom fully and demonstrates its implications for privacy: that deliberation is internal, preferences are subjective, and information asymmetry is therefore structural to human action.

### Murray Rothbard and Natural Law

Rothbard extended Misesian praxeology into political philosophy. Where Mises remained carefully value-free, describing what is without prescribing what ought to be, Rothbard argued that normative conclusions could be derived from the nature of human action.

Rothbard developed a natural law theory of property rights. Humans act; action requires bodies; therefore individuals have natural rights to their own bodies. Humans transform nature; transformation creates property; therefore individuals have natural rights to what they create or acquire through voluntary exchange. Aggression, the uninvited use of another's body or property, violates these natural rights.

This framework yields the Non-Aggression Principle (NAP): the initiation of force against persons or property is illegitimate. The NAP provides the ethical foundation for libertarian political theory. It condemns theft, assault, fraud, and their institutionalized forms including taxation and regulation. Voluntary interaction is legitimate; coerced interaction is not.

For privacy, Rothbard's framework establishes that coerced surveillance violates property rights in specific ways: compelling disclosure of private information, monitoring private spaces without consent, and accessing personal papers and communications without permission. Individuals own their bodies, their homes, their papers. Forced entry into these domains constitutes aggression. The state's surveillance apparatus, compelling disclosure and monitoring without consent, is ethically equivalent to theft: taking what belongs to another without permission.

This book adopts Hoppe's argumentation-based derivation of these property rights, developed fully in Chapter 4, rather than Rothbard's natural law approach. The reason is methodological: Rothbard's natural law argument rests on intuitions about human nature that, while widely shared, cannot be demonstrated to someone who denies them. An interlocutor can simply reject the intuition that self-ownership is "natural" or "evident." Hoppe's approach, by contrast, attempts to derive property rights from the structure of argumentation itself, so that denying self-ownership while arguing creates performative contradiction. Whether this derivation succeeds is contested, and Chapter 4 addresses the major objections. But if it succeeds, it provides a foundation that does not depend on shared intuitions, one that binds anyone who enters rational discourse.

### Hans-Hermann Hoppe and Argumentation Ethics

Hoppe provided what he argues is a value-free derivation of libertarian ethics through argumentation ethics. Where Rothbard relied on natural law intuitions, Hoppe sought to derive property rights from the structure of rational discourse itself: to engage in argumentation presupposes control over one's body and mind, and denying self-ownership while arguing creates performative contradiction. Chapter 4 develops this argument fully, addresses major objections, and demonstrates its implications for privacy rights.

### Samuel Konkin and Agorism

Samuel Edward Konkin III extended Austrian analysis into revolutionary strategy. His 1980 *New Libertarian Manifesto* formulated agorism: the achievement of a free society through counter-economic practice rather than political action.^9^

Counter-economics encompasses all peaceful economic activity outside state observation and control. This includes tax avoidance, regulatory arbitrage, alternative currencies, and gray and black markets. Concrete examples illuminate the scope: unlicensed childcare between neighbors, home repairs performed for cash, farmers markets operating without permits, informal lending between friends, homeschooling cooperatives, barter exchanges, cryptocurrency transactions, unlicensed taxi services, and work performed by the undocumented. The counter-economy is not marginal; by some estimates it represents a substantial fraction of economic activity even in developed nations, and a majority in many developing ones. Konkin argued that each transaction escaping surveillance weakens the state's revenue and regulatory reach while demonstrating that coordination does not require state participation. The counter-economy is not merely a survival strategy but the means of transition to a free society.

Konkin rejected political action as legitimizing the system it purports to reform. Voting, lobbying, and party politics implicitly accept the state's authority to make binding decisions. Even successful political victories can be reversed by subsequent legislation. Counter-economics, by contrast, builds functional alternatives that persist regardless of political outcomes.

The strategic insight aligns with Austrian spontaneous order: working counter-economic systems demonstrate that state services are unnecessary, undermining the ideological justification for state power. Rather than persuading legislatures to permit freedom, build systems that provide freedom regardless of what authorities decide. Rather than convincing courts to protect rights, make violations technically difficult.

Konkin's framework provides the economic logic underlying cypherpunk practice. Encrypted communication enables counter-economic coordination. Anonymous payment enables counter-economic value transfer. Decentralized networks enable counter-economic commerce. The synthesis is practical: build the parallel economy one transaction at a time.

### The Austrian Method Applied to Privacy

The Austrian tradition establishes three categories of conclusions about privacy: descriptive (privacy as inherent to action), normative (Hoppe's argumentation ethics), and economic (privacy's role in market coordination). Part II develops these foundations in full. The remainder of this chapter turns to the cypherpunk tradition, which demonstrates how these theoretical requirements can be implemented.

## 2.2 The Cypherpunk Approach: Code as Law

### David Chaum: Cryptographic Foundations

David Chaum laid the mathematical foundations for privacy-preserving digital systems before most people understood what digital systems would become. His work in the early 1980s anticipated problems that would not become widely recognized for decades.

In 1982, Chaum's dissertation proposed the first digital payment protocol. The following year, his paper "Blind Signatures for Untraceable Payments" introduced a cryptographic primitive essential for digital privacy.^2^ A cryptographic primitive is a fundamental building block: a basic operation that can be combined with others to construct more complex cryptographic systems. The primitive Chaum introduced, the blind signature, allows one party to sign a message without knowing its contents, enabling anonymous transactions that are nonetheless verifiable.

Traditional payment systems require identification because banks must track ownership. But this surveillance capability enables comprehensive monitoring of economic activity. Chaum recognized that cryptography could break this link. Using blind signatures, a bank could issue anonymous digital tokens: verifiable without revealing who spent them.

Chaum's most significant contribution was conceptual: privacy can be designed into systems from the foundation instead of layered on afterward. Traditional approaches treat privacy as a policy constraint, restricting how information may be used after collection. Chaum showed that systems could be built to avoid collecting identifying information in the first place.

This insight connects to what this book calls the Axiom of Resistance. Privacy policies depend on institutional enforcement and can be changed or ignored. Privacy architectures depend on mathematical properties that cannot be overridden. Chaum proved that architecturally enforced privacy was technically achievable.

### Richard Stallman: Software Freedom

While Chaum developed cryptographic tools for privacy, Richard Stallman articulated why users must control the software they depend on. In 1983, Stallman announced the GNU Project to create a free operating system; in 1985, he founded the Free Software Foundation and published the GNU Manifesto.^6^

Stallman distinguished "free as in freedom" from "free as in price." Free software grants users four essential freedoms: to run the program for any purpose, to study and modify the source code, to redistribute copies, and to distribute modified versions. The freedom to modify is essential because software that cannot be changed cannot be fixed or improved by its users; they remain dependent on the original developer's decisions and priorities. The freedom to distribute, both original and modified versions, enables communities to maintain and improve software collectively, ensuring no single party controls its development. When proprietary software is abandoned or its developer becomes hostile, users are trapped. When free software faces the same situation, the community can fork it and continue development independently.

The GNU General Public License, published in 1989, deployed a legal innovation that parallels cypherpunk technical innovation. The GPL uses copyright law against its original purpose: instead of restricting copying, it guarantees that software remains free. Any derivative work must preserve the same freedoms. Copyright becomes the mechanism for ensuring freedom rather than restricting it, just as cryptography becomes the mechanism for ensuring privacy rather than state secrecy. From an Austrian perspective, Stallman's framework aligns with the analysis of information and property developed in Chapter 6: ideas are non-rivalrous, copying does not deprive the original holder, and restrictions on sharing impose artificial scarcity through state enforcement rather than reflecting natural property rights.

Free software philosophy establishes a precondition for cypherpunk practice. Privacy tools must be open source; users cannot trust software they cannot verify. Every major privacy system examined in this book, including PGP, Tor, Bitcoin, and Signal, publishes its source code for inspection. The pattern identified in Chapter 18, that open source enables auditing and trust, traces directly to Stallman's insight that users require the freedom to verify what their software does.

### Timothy May: Political Implications

While Chaum focused on technical possibility, Timothy May articulated the political implications. A physicist and former Intel engineer, May wrote the Crypto-Anarchist Manifesto in 1988, predicting with accuracy the developments of the following decades.^3^

May's central insight was that cryptography enables anonymous interaction at scale:

"Computer technology is on the verge of providing the ability for individuals and groups to communicate and interact with each other in a totally anonymous manner. Two persons may exchange messages, conduct business, and negotiate electronic contracts without ever knowing the True Name, or legal identity, of the other."

This capability, May argued, would "alter completely the nature of government regulation, the ability to tax and control economic interactions, the ability to keep information secret, and will even alter the nature of trust and reputation."

May recognized that anonymous systems require alternative coordination mechanisms. Traditional trust depends on identity; anonymous trust must operate differently. His answer was reputation: "Reputations will be of central importance, far more important in dealings than even the credit ratings of today."

This insight aligns with Austrian analysis of market coordination. Reputation systems are market phenomena: they emerge through voluntary interaction, aggregate dispersed information, and enable coordination without central authority. Contemporary anonymous systems, from cryptocurrency to darknet markets, validate May's prediction by operating primarily through pseudonymous reputation.

### Eric Hughes: The Cypherpunk Manifesto

Eric Hughes articulated the ethical framework underlying cypherpunk practice. His 1993 manifesto transformed May's political predictions into a program for action.^4^

Hughes's concept of selective disclosure, introduced in Chapter 1, finds its technical expression in his manifesto's program. Privacy, Hughes argued, requires anonymous transactions: systems enabling exchange without identity disclosure. "An anonymous system empowers individuals to reveal their identity when desired and only when desired; this is the essence of privacy."

Hughes's most influential statement defined the cypherpunk approach: "Cypherpunks write code." This commitment to implementation over advocacy distinguishes cypherpunks from other privacy movements. Legal advocacy may fail; political victories may be reversed. Code persists. Once privacy-preserving software exists and spreads, its removal becomes far more difficult than passing legislation.

Hughes also recognized the collective action problem: individual adoption of privacy tools provides limited protection if counterparties do not use compatible tools. His response was publishing code freely: reducing barriers to adoption and accelerating network growth.

### John Perry Barlow: A Declaration of the Independence of Cyberspace

John Perry Barlow gave the cypherpunk movement its most eloquent political expression. A Wyoming rancher, Grateful Dead lyricist, and co-founder of the Electronic Frontier Foundation, Barlow wrote his declaration in February 1996 while attending the World Economic Forum in Davos, Switzerland.

The immediate trigger was the Communications Decency Act, passed by the U.S. Congress as part of the Telecommunications Act of 1996. The Act would have criminalized "indecent" speech online, imposing felony charges and fines up to $100,000 for content that was legal in print. Barlow saw this as territorial governments attempting to impose jurisdiction over a domain they did not understand and could not control.

His declaration addressed the "Governments of the Industrial World" with defiance: "You are not welcome among us. You have no sovereignty where we gather." Cyberspace, Barlow argued, was not a place governments could govern. It had no elected officials, no borders, no standing armies. "Our identities have no bodies, so, unlike you, we cannot obtain order by physical coercion."

The declaration asserted that governance in this new domain would emerge from ethics, self-interest, and the nature of the medium itself rather than from legislation. "We are forming our own Social Contract. This governance will arise according to the conditions of our world, not yours." Cyberspace was "a world that all may enter without privilege or prejudice accorded by race, economic power, military force, or station of birth."

Barlow's declaration captured the optimism of the early digital frontier. It articulated the hope that cryptographic tools and decentralized networks would render traditional state control technically impossible, enabling communities to govern themselves through consent rather than force. The declaration went viral, copied onto tens of thousands of websites, and became a foundational document of internet culture.

The optimism proved partially naive. Governments did extend control into cyberspace through surveillance infrastructure, platform regulation, and jurisdictional pressure on service providers. Yet Barlow's core insight persisted: the architecture of digital communication creates possibilities for coordination and privacy that territorial governance struggles to prevent. The declaration was not wrong about what was possible, only optimistic about how easily it would be achieved.

### A Declaration of Separation

Fourteen years after Barlow's declaration, a different document appeared. "A Declaration of Separation" (2010), published anonymously under the name "The Free and Unashamed," marked a more mature articulation of withdrawal from state systems.

Where Barlow addressed governments with defiance, this declaration addressed humanity with determination. Where Barlow's tone was optimistic, proclaiming a new frontier, this declaration was realistic about the difficulty ahead. "We claim the right to exist, and we will defend it. We do not seek to overthrow anything. We do not seek to control anything. We merely wish to be left alone."

The declaration explicitly rejected political engagement: "We no longer see any benefit in working through the world's systems." Political victories could be reversed; rights granted by governments could be revoked by governments. The strategic conclusion was withdrawal rather than reform. "We are living as free people, wherever and however we can. We are building and growing, in spite of the artificial 'economy.'"

The document outlined a program of building parallel structures: "We are using networking, cryptography, sound money, digital currency and anonymous messaging to expand the realm of the free and reduce the realm of the governed." Each technology served a strategic purpose: networking enabled coordination without geographic constraint; cryptography protected communication from surveillance; sound money preserved value outside central bank manipulation; digital currency enabled transfer outside banking surveillance; anonymous messaging protected identity while enabling collaboration.

The declaration articulated principles of negative rights, voluntary exchange, and decentralized organization that aligned with both Austrian economics and cypherpunk practice. Its closing captured the strategic posture: "If you want to be a part of us, be free and don't expect us to feed you. If you want to help, put your time and resources into the creation of new ways to build and create, rather than into reformation of the old."

The arc from May's Crypto Anarchist Manifesto (1988) through Barlow's declaration (1996) to A Declaration of Separation (2010) traces the movement from prediction through hope to determined construction. Cryptographic tools would enable new forms of social organization beyond state control; the question was not whether, but how.

### The Second Realm

Smuggler and XYZ articulated the most developed strategic framework for cypherpunk practice in their 2015 work *Second Realm: Book on Strategy*.^10^ Building on Konkin's agorism, Hakim Bey's temporary autonomous zones, and cypherpunk digital freedom, they formulated a comprehensive approach to building free spaces within an unfree world.

The First Realm is the state-supervised economy: regulated, surveilled, permitted. Every transaction is potentially monitored; every relationship is potentially documented; every activity is potentially controlled. The Second Realm operates outside state supervision: unregulated, private, permissionless. The distinction concerns governance rather than legality. Some Second Realm activity is perfectly legal but unsurveilled. Some First Realm activity is illegal but occurs within state-supervised systems where violations are tracked and punished.

The framing shifts focus from what is traded to how trading is coordinated. First Realm commerce operates under state rules: disputes resolved through courts, identity verified through government documents, payments processed through regulated intermediaries. Second Realm activity operates under different rules: disputes resolved through reputation and arbitration, trust built through cryptographic proof rather than legal identity, value transferred through channels outside surveillance.

The strategic insight is that Second Realm spaces can be created now, in parallel to existing systems, without waiting for political change or societal transformation. A private transaction using cash or cryptocurrency exists in the Second Realm regardless of the surrounding legal environment. An encrypted conversation occurs in the Second Realm even if both parties are physically located in surveilled jurisdictions. Each Second Realm interaction expands the domain of the ungoverned.

Smuggler and XYZ emphasized the merger of physical and digital realms. Early cypherpunk thinking focused on digital spaces: encrypted networks, anonymous communication, digital cash. Second Realm strategy extends to physical interactions: in-person trades, local communities, geographic spaces operating by alternative rules. The tools remain digital (encryption, cryptocurrency, anonymous communication), but the goal is comprehensive: building a parallel society rather than merely a parallel internet.

The framework rejects the common libertarian assumption that freedom requires winning a political battle or achieving a utopian society. Freedom can be practiced now, in the spaces between state control. The question is not how to abolish the state but how to live as though it were irrelevant. Each successful Second Realm interaction demonstrates that state services are unnecessary and undermines the ideological justification for state power.

### Digital Cash Precursors

Between Hughes's manifesto and Bitcoin's emergence, several cypherpunks developed key precursor technologies.^5^

Adam Back invented Hashcash in 1997, a proof-of-work system originally designed to combat email spam. The concept of computational work as a scarce resource, costly to produce but easy to verify, became foundational for Bitcoin's consensus mechanism. Wei Dai proposed B-money in 1998, describing a system where "money is created, by the participants themselves, from computation work"; Satoshi Nakamoto cited B-money in the Bitcoin whitepaper. Nick Szabo developed Bit Gold in 1998, the closest precursor to Bitcoin. Bit Gold used proof-of-work to create digital scarcity, with each solution becoming part of the next challenge. Szabo also pioneered smart contracts: self-executing agreements where terms are written in code. Hal Finney created the first reusable proof-of-work system in 2004 and later received the first Bitcoin transaction from Satoshi Nakamoto; Finney understood that digital cash required solving the double-spending problem without central authority.

These cypherpunks solved individual pieces of the digital cash puzzle. Nakamoto's synthesis combined their insights into a working system.

### The Cypherpunk Method

The cypherpunk tradition exhibits distinctive methodological characteristics. It prioritizes implementation over theory: ideas are validated by building working systems, and a cryptographic protocol that works proves its possibility regardless of theoretical objections, while a system that fails teaches what does not work. Code serves as proof; mathematical demonstrations and running code establish what is possible, bypassing arguments about whether anonymous transactions "should" be allowed through systems that simply enable them. The tradition emphasizes open source publication, with code published for review, use, and modification. Security depends on scrutiny; obscurity provides no protection. Publishing enables network growth and collective verification. Finally, the tradition advances through iteration, learning from failure. Failed systems such as DigiCash, E-gold, and Liberty Reserve teach lessons, while successful systems such as Tor, Bitcoin, and Signal demonstrate viability. The tradition advances through empirical selection.

## 2.3 Independent Convergence: Why Both Reached the Same Place

### Different Methods, Same Reality

The Austrian and cypherpunk traditions employed radically different methods yet reached convergent conclusions. This convergence is not coincidental; it reflects the logical structure of human action and voluntary coordination.

Praxeology proceeds through logical deduction from the action axiom. It derives what must be true given the structure of human action, independent of contingent circumstances.

Cypherpunk practice proceeds through engineering and experimentation. It builds systems, observes what works, and iterates toward better solutions.

Both methods investigate the same underlying reality: how humans act and coordinate. Austrian economists discover this structure through analyzing action's presuppositions. Cypherpunks discover it through building systems that must accommodate action's requirements to function.

### Shared Conclusions

Both traditions reach compatible conclusions. First, individual action is fundamental: Austrian methodological individualism treats the acting individual as the basic unit of analysis, while cypherpunks build systems empowering individuals rather than institutions. Second, voluntary coordination requires privacy; Austrian analysis shows that exchange depends on controlled disclosure, and cypherpunk systems enable voluntary interaction by making surveillance technically difficult. Third, spontaneous order emerges without central design. Austrian economics describes how markets coordinate through decentralized price signals; cypherpunk protocols coordinate through decentralized consensus mechanisms. Neither requires a central planner. Fourth, coercion distorts coordination. Austrian theory shows that intervention distorts price signals and calculation; cypherpunk practice shows that surveillance distorts behavior and exchange. Both conclude that voluntary systems coordinate better than coerced ones.

### Why Convergence Is Evidence

The convergence validates both approaches. If Austrian deduction and cypherpunk experimentation, proceeding independently, reach the same conclusions, this suggests both have discovered something true about reality, not artifacts of their methods.

A system that violates Austrian requirements will fail to support purposeful behavior. A system that ignores what cypherpunk experience demonstrates will fail in practice. Successful systems satisfy both theoretical requirements and practical constraints because both traditions investigate the same reality.

Cypherpunks and Austrians reach the same conclusions despite different starting points for this reason. They discover the same constraints because the constraints are real. Austrian theory predicts what cypherpunk practice confirms; cypherpunk practice demonstrates what Austrian theory requires.

### What the Synthesis Offers

Neither tradition is complete alone.

Praxeology without cypherpunk implementation offers insight without application. One can understand why privacy enhances coordination without knowing how to achieve it technically. Theoretical understanding does not produce digital cash; that requires cryptographic engineering.

Cypherpunk practice without Austrian understanding risks building systems that fail economically. Not every privacy tool succeeds; many fail through inadequate attention to incentives and coordination requirements. Austrian analysis identifies why some approaches must fail and what requirements successful approaches must meet.

The synthesis offers both: praxeology explains why privacy-preserving systems matter for human coordination; cypherpunk practice demonstrates how to build them. This book develops this synthesis: theoretical foundations from Austrian logic, practical implementation from cypherpunk engineering.

## Chapter Summary

Two intellectual traditions, developed independently, arrived at compatible conclusions about privacy.

The Austrian tradition, from Menger's methodological individualism through Mises's praxeology to Rothbard's natural rights, Hoppe's argumentation ethics, and Konkin's agorism, establishes privacy through deductive reasoning from the structure of human action. Privacy is built into the structure of action (descriptive). Privacy is ethically required as shown by Hoppe's argumentation ethics (normative). Privacy enhances market coordination (economic). Counter-economics provides the strategic framework for building free spaces through parallel institutions rather than political reform.

The cypherpunk tradition, from Chaum's blind signatures through Stallman's software freedom, May's political predictions, Hughes's manifesto, Barlow's declaration of digital sovereignty, to the digital cash precursors, demonstrates privacy through technical implementation. Working systems prove what is possible regardless of theoretical objections. Code that functions validates the possibility it embodies. The Second Realm framework extends this practice beyond digital spaces to comprehensive parallel society.

The traditions converge because both investigate the same reality: how humans act and coordinate. Their independent agreement suggests both have discovered actual features of human action, not artifacts of their methods.

This book synthesizes both traditions. Part II develops the philosophical foundations. Part III applies Austrian economic analysis. Parts IV and V examine threats and technical implementation. Part VI addresses practical application. Throughout, Austrian theory explains why; cypherpunk practice demonstrates how.

---

## Footnotes

^1^ Eric Hughes, "A Cypherpunk's Manifesto" (1993). Hughes was a mathematician and programmer who co-founded the Cypherpunks mailing list.

^2^ David Chaum, "Blind Signatures for Untraceable Payments," in *Advances in Cryptology: Proceedings of Crypto 82*, ed. David Chaum, Ronald L. Rivest, and Alan T. Sherman (New York: Plenum Press, 1983), 199-203.

^3^ Timothy C. May, "The Crypto Anarchist Manifesto" (1988), available at the Nakamoto Institute.

^4^ Eric Hughes, "A Cypherpunk's Manifesto" (March 9, 1993).

^5^ For the historical relationship between cypherpunk thought and Bitcoin, see the Nakamoto Institute's collection of primary sources. On Hashcash, see Adam Back, "Hashcash - A Denial of Service Counter-Measure" (2002). On B-money, see Wei Dai, "B-money" (1998). On Bit Gold, see Nick Szabo, "Bit Gold" (2005).

^6^ Richard Stallman, "The GNU Manifesto" (1985). See also "What is Free Software?" at gnu.org for the canonical statement of the four freedoms.

^7^ On Austrian methodology, see Ludwig von Mises, *Human Action* (1949), particularly the methodological chapters. On the Menger-Mises-Rothbard lineage, see Hans-Hermann Hoppe, *Economic Science and the Austrian Method* (1995).

^8^ For Hoppe's argumentation ethics, see Hans-Hermann Hoppe, *A Theory of Socialism and Capitalism* (1989), Chapter 7: "The Ethical Justification of Capitalism and Why Socialism Is Morally Indefensible."

^9^ Samuel Edward Konkin III, *New Libertarian Manifesto* (1980). Konkin coined the term "agorism" from the Greek "agora" (open marketplace) and developed counter-economics as the strategic application of libertarian principles.

^10^ Smuggler and XYZ, "Second Realm: Book on Strategy" (2015). The Second Realm concept describes parallel economic structures operating outside state supervision.
