# Chapter 3: The Action Axiom: Privacy as Structural Feature

*"Human action is purposeful behavior."*

Ludwig von Mises^1^

## Introduction

The Action Axiom, formulated by Ludwig von Mises, states that human action is purposeful behavior. This is not an empirical generalization subject to falsification but a self-evident truth: any attempt to deny it is itself an action, purposeful behavior directed toward convincing others, thereby confirming what it attempts to deny.

From this axiom, we derive that privacy exists as a structural feature of human action. Deliberation is internal. Preferences are subjective. Information asymmetry between actor and observer is inherent to the structure of purposeful behavior. These are descriptive facts about how action works. Whether privacy should be protected is a normative question addressed in Chapter 4.

## 3.1 The Action Axiom

### The Self-Evident Starting Point

Ludwig von Mises identified the foundation of all economic analysis: human action is purposeful behavior.^2^ To act is to employ means toward ends according to ideas about causal relationships. Action is not mere motion but directed effort aimed at changing circumstances from a less satisfactory state to a more satisfactory one.

This statement is self-evident in a precise sense: its denial refutes itself. To argue that action is not purposeful, one must purposefully construct an argument, purposefully select evidence, purposefully direct mental effort toward persuasion. The attempt to deny purposeful behavior is itself purposeful behavior, confirming what it seeks to deny. The pattern is not rhetorical cleverness but logical necessity: the denial is performatively self-refuting.

The Action Axiom is therefore a priori: known prior to and independent of particular experience. We do not discover it through observation but recognize it through reflection on what action entails. Any experience we could have is itself action and therefore presupposes what the axiom states.

### What the Axiom Asserts

The Action Axiom asserts several things simultaneously. Action is purposeful in that it aims at goals; the actor envisions a preferred future state and directs behavior toward achieving it. Action without purpose is not action but reflex, accident, or mechanical motion. Action also employs means toward ends: the actor perceives alternative pathways toward desired outcomes and selects among them. This selection presupposes evaluation, judging which means are appropriate for which ends.

Action involves choosing among alternatives. To act is to give up some possibilities in favor of others. The chosen course excludes unchosen courses, which implies that the actor could have done otherwise. Finally, action is conscious behavior. The actor is aware of what they are doing and why. Unconscious behavior, however complex, is not action in the praxeological sense.

### What the Axiom Does Not Assert

Equally important is what the Action Axiom does not assert. The axiom does not claim that actions are rational in any substantive sense; it says action is purposeful, not that purposes are wise or means are effective. An actor may pursue foolish goals with inappropriate methods, and this is still action. Nor does the axiom assert that actors possess complete information. Actors act under uncertainty with incomplete knowledge; the axiom describes the structure of action, not its success.

The axiom does not assert that action is morally evaluable. It is descriptive, saying nothing about whether particular actions are good, right, or permissible. Ethical evaluation requires additional premises. Finally, the axiom does not assert that actions should be free from interference, for this would be a normative claim. The axiom describes how action works; it does not prescribe how action should be treated.

## 3.2 Internal Deliberation and Subjective Valuation

### Deliberation Occurs in the Mind

Action requires choice among alternatives. Choice requires deliberation: weighing options, considering consequences, evaluating trade-offs. Where does this deliberation occur?

It occurs in the mind of the actor. This is not a contingent fact about how humans happen to work but inherent to what deliberation means. To deliberate is to engage in internal mental processes: imagining alternatives, projecting outcomes, comparing evaluations. These processes are intrinsically internal; they occur within the deliberating subject.

An external observer cannot access another's deliberation directly. They can observe behavior, record statements, measure physiological responses. But the actual mental process, the weighing and evaluating that constitutes deliberation, remains internal to the deliberator. Deliberation, by its nature, is internal.

This claim about inherent inaccessibility deserves scrutiny. One might object that current inaccessibility is merely a function of current technology, not an essential feature of deliberation. Future neuroscience might develop methods to "read" deliberative processes directly from brain states. If so, the privacy of deliberation would be empirically contingent, not structurally guaranteed.

The move from phenomenological observation (deliberation currently appears internal to us) to structural claim (deliberation is inherently internal) is contestable. Perhaps what we experience as private deliberation will someday be readable through sufficiently advanced brain imaging. This would not refute the action axiom itself, which concerns purposeful behavior, not its observability. But it would qualify the claim that information asymmetry is permanently structural rather than technologically contingent.

For present purposes, the relevant point is that deliberation is currently and for the foreseeable future internal and inaccessible. The privacy implications developed in this chapter hold given actual human capacities. Whether future technology could change this is an empirical question that does not affect current analysis.

### Subjective Valuation

Action aims at goals the actor values. But value is not an objective property of things; it is a relation between an evaluating subject and the object evaluated. The same object may be valued differently by different actors, or by the same actor at different times. Value exists only in the act of valuing.

Menger identified this insight, developed by Mises: value is subjective.^3^ It originates in the evaluating mind, not in the evaluated object. No "objective value" exists independent of someone's valuation. Prices emerge from the interaction of subjective valuations; they do not measure pre-existing objective values.

For privacy, this has immediate implications. An actor's valuations exist in their mind. No external observer can access another's value rankings directly. They can infer preferences from observed choices, but the underlying subjective experience of valuing remains internal and private.

### Ordinal Preference Rankings

Preferences are ordinal, not cardinal. Actors rank alternatives as more or less preferred, not as having measurable quantities of utility. An actor prefers A to B to C; they do not "have 50 utils from A, 30 from B, 20 from C."

This ordinal structure means preferences cannot be aggregated across individuals. No method exists to add your preference ranking to mine to produce a collective ranking. Each person's preference structure is their own, incommensurable with others'.

The privacy implication is direct: preference rankings exist only in individual minds. No external process can access, aggregate, or override individual preferences without losing what preferences actually are. Collective decisions that claim to represent "social preferences" are metaphorical at best.

## 3.3 Information Asymmetry and Control

### Structural Information Asymmetry

From the preceding analysis, a structural fact emerges: actors necessarily possess information that observers lack.

The actor knows their preferences, plans, and evaluations. The observer can only infer these from external evidence. The actor experiences their deliberation directly. The observer has access only to its behavioral outputs. This asymmetry is not contingent but structural: it follows from what deliberation and valuation are.

Privacy in its most basic sense is information asymmetry between actor and observer that is built into the structure of action. Privacy exists as a descriptive fact before any normative claim is made about whether it should be protected or violated.

### Control Over Disclosure

The actor, by virtue of having internal states, faces choices about disclosure. They can reveal their preferences through action or statement. They can conceal their plans by refraining from communication. They have, in the relevant sense, control over what information about their internal states reaches others.

This control is not absolute. Others can infer preferences from observed behavior. Physiological states may be detectable. Coercion may compel disclosure. But the baseline condition is that internal states are internal: accessible to the actor, inaccessible to others except through the actor's disclosure or others' inference.

This is what Hughes meant by "selective disclosure": the power to choose what to reveal and to whom.^4^ The Action Axiom establishes that this capacity is built into action itself. Whether it should be protected, enhanced, or overridden is a separate question.

### Surveillance as Externally Imposed Transparency

Surveillance attempts to overcome information asymmetry by making the actor's internal states accessible to observers. Recording behavior, monitoring communications, and tracking transactions all aim to reduce the asymmetry between what actors know about themselves and what observers know about them.

The Action Axiom does not say surveillance is wrong. It says that surveillance attempts to overcome a structural feature of action. Whether such attempts succeed, fail, or should be permitted involves empirical and normative questions beyond the axiom itself.

What the axiom establishes is that the asymmetry being overcome is inherent to action. Surveillance attempts to overcome an inherent property of purposeful behavior.

## 3.4 Scope and Limitations

This section explicitly states what Chapter 3 does and does not establish. Precision here prevents the overreach that weakens many privacy arguments.

### What This Chapter Establishes

**Privacy is a structural feature of action.** Deliberation is internal, preferences are subjective, and information asymmetry between actor and observer is inherent to purposeful behavior. This is descriptive: a fact about how action works.

**The Action Axiom is self-evident.** Denial is performatively self-refuting. This gives the axiom a strong epistemic status: it cannot be coherently denied.

**Subjective valuation means preferences are internal.** No external observer can directly access another's value rankings. Preferences exist only in individual minds.

### What This Chapter Does NOT Establish

**That privacy is "necessary" in any strong normative sense.** People act under surveillance constantly. Action occurs even when privacy is violated. The axiom establishes that privacy is built into the structure of action, not that privacy is required for action to occur.

**That privacy should be protected.** This would be a normative claim requiring additional argument. The Action Axiom is descriptive; it says what is, not what ought to be. Chapter 4 develops the normative case.

**That violating privacy is wrong.** Ethical evaluation requires ethical premises. The Action Axiom provides none. To derive that privacy violations are wrong requires argument beyond this chapter.

**Property rights.** The axiom does not establish that actors own their thoughts, their bodies, or anything else. Property is a normative concept requiring normative foundations.

**The Non-Aggression Principle.** The NAP holds that initiating force is illegitimate. This is an ethical claim that does not follow from descriptive premises alone. Deriving the NAP requires Hoppe's argumentation ethics.

## Chapter Summary

The Action Axiom, that human action is purposeful behavior, is self-evident. Denial is performatively self-refuting. From this axiom we derive descriptive facts about action's structure.

Deliberation is internal: it occurs in the actor's mind. Preferences are subjective: they exist only in individual acts of valuing. Information asymmetry is structural: actors necessarily possess information about their internal states that observers lack. This is privacy as inherent to action.

The normative case for protecting this structural feature requires Chapter 4's argumentation ethics.

---

## Footnotes

^1^ Ludwig von Mises, *Human Action: A Treatise on Economics*, Scholar's Edition (Auburn, AL: Ludwig von Mises Institute, 1998), 11.

^2^ Mises, *Human Action*, 11-29. The opening chapters develop the action axiom and its immediate implications. See also Murray N. Rothbard, *Man, Economy, and State*, Scholar's Edition (Auburn, AL: Ludwig von Mises Institute, 2009), 1-77, for an alternative presentation of the same foundations.

^3^ Carl Menger, *Principles of Economics*, trans. James Dingwall and Bert F. Hoselitz (Auburn, AL: Ludwig von Mises Institute, 2007 [1871]), 114-174. Menger's subjective theory of value revolutionized economics by locating value in the evaluating mind, not in objective properties of goods.

^4^ Eric Hughes, "A Cypherpunk's Manifesto" (1993): "Privacy is the power to selectively reveal oneself to the world."

^5^ On the distinction between descriptive and normative claims in Austrian economics, see Hans-Hermann Hoppe, *Economic Science and the Austrian Method* (Auburn, AL: Ludwig von Mises Institute, 1995), particularly the discussion of praxeology as value-free science. Mises insisted that economics describes what is, not what ought to be; ethical evaluation requires additional premises.
