# Chapter 4: The Argumentation Axiom and Self-Ownership

*"Any proposition must have a proposer, and the proposer's right to make his proposal must be presupposed."*

Hans-Hermann Hoppe^1^

## Introduction

This chapter is normative. It presents an argument for ethical conclusions.

Chapter 3 established descriptive facts: privacy is a structural feature of human action. But description alone does not yield prescription. That action has a certain structure does not, by itself, tell us what we should do about it.

This chapter develops the normative case. Hans-Hermann Hoppe argues that engaging in argumentation presupposes certain conditions, and that denying these conditions while arguing creates performative contradiction. From this, Hoppe derives self-ownership, property rights, and the Non-Aggression Principle.

This argument has been debated for nearly four decades. Philosophers have raised objections, and Hoppe and his defenders have addressed them. This chapter presents the argument, examines the major objections, and shows why the argument succeeds. The is-ought problem, which has vexed philosophy since Hume, receives a sophisticated solution: the argument does not derive ought from is but demonstrates that certain normative claims cannot be coherently denied in rational discourse.

## 4.1 The Argument: Performative Contradiction

### Origins in Discourse Ethics

Hoppe's argumentation ethics draws on the work of Jürgen Habermas and Karl-Otto Apel, who developed discourse ethics in the tradition of transcendental pragmatics.^2^ Both sought to identify presuppositions of rational discourse, conditions that must be met for meaningful argumentation to occur.

Habermas and Apel argued that certain norms are implicit in the act of argumentation itself. If these norms are necessary for argumentation, then denying them while arguing creates what they called performative contradiction: the denial is undermined by the act of denying.

Hoppe accepted this methodological approach but rejected Habermas and Apel's conclusions about which norms discourse presupposes. Where they derived social-democratic policies, Hoppe derived self-ownership, private property, and libertarian ethics. The method is shared; the conclusions differ.

### The Structure of the Argument

Hoppe's argument proceeds as follows:

**Premise 1**: We are engaged in argumentation. The argument applies only within this context; if we are not arguing, it does not apply.

**Premise 2**: Argumentation is a specific form of action with specific presuppositions. Not all action is argumentation, but all argumentation is action.

**Premise 3**: To argue, one must have exclusive control over one's body. You cannot argue without using your body to produce sounds, gestures, or writing. If you lacked control over your body during argumentation, you could not formulate, express, or defend your position.

**Premise 4**: To argue, one must have exclusive control over one's mind. Argumentation requires formulating thoughts, evaluating evidence, and reaching conclusions. If your mental processes were under another's control, you could not engage in actual argumentation.

**Conclusion 1**: Anyone engaged in argumentation implicitly presupposes exclusive control over body and mind. Self-ownership means precisely this: exclusive control over one's own person.

**Premise 5**: To deny self-ownership while arguing is to engage in performative contradiction. The denier must use exclusive control over their body and mind to formulate and express the denial. The act of denying presupposes what the denial rejects.

**Conclusion 2**: Self-ownership cannot be coherently denied in argumentation. Any attempt to deny it confirms it.

### Extension to Property Rights

Hoppe extends the argument from self-ownership to external property:

**Premise 6**: Argumentation occurs in time and space. Arguers occupy positions, use resources, and exist during the period of discourse.

**Premise 7**: To engage in argumentation, one must have access to physical resources, at minimum a standing point from which to argue.

**Premise 8**: If resources could be taken from arguers during discourse, argumentation could not proceed reliably.

**Premise 9**: The principle that best protects argumentation is original appropriation: the first user of an unowned resource establishes property rights through mixing labor with the resource.

**Conclusion 3**: Property rights are presupposed by argumentation. Denying property rights while benefiting from them to argue creates performative contradiction.

### The Non-Aggression Principle

From self-ownership and property rights, the Non-Aggression Principle follows:

If individuals own themselves and their legitimately acquired property, then uninvited interference with person or property violates ownership rights. This interference is aggression. The NAP holds that initiating such aggression is illegitimate; force is justified only in response to prior aggression.

The NAP thus rests on Hoppe's argumentation ethics, not on the Action Axiom alone. Chapter 3 could not derive the NAP because Chapter 3 was purely descriptive. The normative foundation comes here.

## 4.2 Objections and Responses

Hoppe's argument has faced substantial criticism. Intellectual honesty requires presenting the strongest objections and evaluating responses.

### The Use-Ownership Gap (Murphy and Callahan)

Robert Murphy and Gene Callahan raised what many consider the most serious objection: Hoppe's argument establishes at most that arguers have use of their bodies during discourse, not that they own their bodies.^3^

The objection: "Someone can deny the libertarian ethic, and yet concede to his opponents the use of their bodies for debate. There is nothing contradictory about this."

A socialist, for instance, could say: "I grant you the use of your body for this argument. But after we finish arguing, property arrangements will be determined collectively." This position grants temporary use without conceding permanent ownership.

Murphy and Callahan further argue that even if self-ownership is established, Hoppe's argument applies only to parts of the body used in argumentation: "At best, Hoppe has proven that it would be contradictory to argue that someone does not rightfully own his mouth, ears, eyes, heart, brain, and any other bodily parts essential for engaging in debate."

Several scholars have addressed this objection.^4^ Walter Block argues that the distinction between use and ownership is artificial in this context; to have exclusive use sufficient for argumentation is to have the essential content of ownership. The socialist who says "I grant you use of your body for this argument, but afterward property arrangements will be determined collectively" has not escaped the contradiction. For the proposal itself presupposes that his body and mind are his to use in making it, that his words are his, that his position in the argument is his to defend. The "temporary permission" framing smuggles in ownership under another name.

Frank van Dun clarifies what happens when someone refuses to acknowledge these presuppositions: they place themselves outside the community of rational discourse.^5^ Such a person has not "refuted" argumentation ethics but rather declined to engage in argumentation at all. They become what van Dun terms an "outlaw" in the original sense: one who has placed themselves outside the framework that makes reasoned dispute resolution possible. The argument does not claim such persons cannot exist; it establishes that they cannot coherently claim the protections they deny to others.

Hatim Kheir offers a further reformulation that strengthens the argument.^6^ When parties choose arbitration to resolve disputes, they implicitly accept a framework that extends beyond immediate possession. Arbitration requires the arbitrator to decide based on objective facts and objective principles, not personal interest. The very act of submitting a dispute to a neutral third party presupposes that claims can be justified through intersubjectively verifiable standards. Kheir argues that these standards necessarily include first-user acquisition and persistent ownership: if property claims vanished whenever possession lapsed, arbitration of most real disputes would be impossible. The structure of arbitration thus presupposes ownership, not mere use.

Far from "shifting ground," Kheir's argument shows the robustness of argumentation ethics: whether one begins with argumentation in general or arbitration specifically, the same conclusions follow. The logic of rational discourse, in any of its forms, presupposes the property norms that make such discourse possible.

### The Partial Application Objection

Related to the above: even if Hoppe's argument establishes some self-ownership, it applies only during argumentation. What about when people are not arguing?

A totalitarian could argue: "During this debate, you have self-ownership. Once we stop debating, different rules apply." Hoppe's argument, being about argumentation, seems to have nothing to say about non-argumentative contexts.

The response is that principles discovered through argumentation must be universalizable to function as principles at all.^7^ Argumentation is the activity of providing reasons for assertions, seeking mutual understanding through rational exchange. When one proposes a norm to another person as binding on both, that norm must be universalizable to be acceptable; a particularistic norm ("I may do X to you, but you may not do X to me") provides no reason the other party could accept.

The universalizability requirement is not an arbitrary assumption but a constitutive feature of argumentation. One who offers only particularistic claims is not arguing but making assertions of power. To say "self-ownership applies during argumentation but not after" is to propose a particularistic norm: the speaker grants himself the right to suspend others' self-ownership when convenient while presumably retaining his own. This provides no reason the other party could accept and thus fails to qualify as argumentation at all.

The distinction between argumentation and mere assertion is what makes rational discourse possible. If one abandons universalizability, any norm whatsoever can be asserted by simply inventing a particularistic exception. Without universalizability, reasoned discourse about norms collapses into assertion and counter-assertion, which is precisely what argumentation exists to transcend. The totalitarian who claims "different rules apply after the debate" has not offered an argument but a declaration of intended force.

### Conflating Control and Ownership

A distinct objection: Hoppe moves from the descriptive fact that arguers control their bodies to the normative claim that they ought to have exclusive control. This conflates is and ought.

The objection: "Just as someone has the ability to control one's self, that does not give rise to why another ought to refrain from physically interfering with that control."

This objection misunderstands the structure of the argument. Hoppe does not argue: "You control your body, therefore you own it." He argues: "You cannot coherently deny self-ownership while arguing, because the denial presupposes what it denies." The ought does not enter through a derivation from is but through the requirements of non-contradictory discourse.

Consider: if someone argues "you have no right to control your body," they must use their own body to make the argument. They must presuppose their right to formulate thoughts, move their vocal cords, gesture, or type. They presuppose that their argument is theirs to make. The performative contradiction is not that control exists but that the denier must exercise the very rights they deny in order to deny them.

Stephan Kinsella offers a complementary defense through the principle of estoppel.^8^ An aggressor who objects to defensive force must claim that force is impermissible. But by committing aggression, he has demonstrated through his actions that force is permissible. He is therefore estopped from objecting: to object, he would have to contradict the principle implicit in his own action. This is not deriving ought from is but showing that certain positions cannot be coherently maintained.

### Objections to the Property Extension

Even granting self-ownership, the extension to external property is separately contested. Why must arguers have private property in external resources? Why not common ownership with rules for access?

Hoppe argues that common ownership regimes cannot be universalized without contradiction. If everyone has equal access to all resources, conflicts over use are inevitable. Two people cannot occupy the same space or use the same tool simultaneously. Some resolution mechanism is needed.

The question is: what resolution mechanism can be justified through argumentation? Any proposed mechanism must be statable as a universalizable principle. "First appropriation establishes rights" is such a principle: it applies equally to all, provides clear conflict resolution, and does not presuppose prior property claims. "The collective decides" is not: it presupposes that someone has the right to speak for "the collective," that boundaries of the collective are defined, and that some mechanism exists for collective decision. Each of these presuppositions requires prior property norms to resolve.

Moreover, to argue for common ownership, one must occupy a position from which to argue. One must have access to resources (a place to stand, air to breathe, a medium of communication) that others cannot simultaneously use in the same way. The arguer for common ownership has already appropriated the resources necessary for making the argument. To then deny that appropriation establishes rights is to deny the legitimacy of the very act by which the denial is made.

Left-libertarian alternatives that accept self-ownership but reject strong property rights face a further difficulty: they must explain how self-ownership can be exercised without property in external resources. To act, one must use space and materials. If these are subject to collective veto, self-ownership becomes nominal rather than effective.

## 4.3 The Is-Ought Question

### The Problem

David Hume observed that many arguments illegitimately move from statements about what is to conclusions about what ought to be. Descriptive premises cannot, by themselves, yield normative conclusions: the is-ought gap.

Does Hoppe's argument bridge this gap, or does it commit Hume's fallacy?

### Hoppe's Solution

Hoppe's argument does not derive ought from is in the manner Hume criticized. The structure is:^9^

1. Argumentation presupposes property in one's body and homesteading. (Descriptive claim about presuppositions)
2. Therefore, no deviation from this ethic can be argumentatively justified. (Conclusion about what can be justified)

The argument does not say: "Things are this way, therefore they ought to be this way." It says: "Anyone who enters the realm of reasoned discourse has already, by that act, presupposed the norms that make discourse possible." The ought does not come from is but from the requirements of non-contradictory rational engagement.

Murray Rothbard recognized the significance of this move, stating that Hoppe had "transcended the famous is/ought, fact/value dichotomy."^10^

### Addressing Remaining Objections

Critics argue that even if certain claims cannot be denied without contradiction, this establishes only a constraint on what can be argued, not what is true. That I cannot coherently deny X while arguing does not prove X is true, only that I cannot coherently deny it.

This objection misunderstands the domain of ethical claims. Ethics concerns how rational agents ought to interact. If a proposed ethical norm cannot be coherently stated without contradiction, that is not merely an inconvenience for the proposer; it is a demonstration that the norm fails as a norm. A "norm" that cannot be consistently advocated is not a norm anyone could follow or recommend. The criterion of non-contradictory assertability is not arbitrary but constitutive of what it means to propose a norm at all.

The objection that ethics might be "about something else entirely" (consequences, virtues, divine commands) does not escape this analysis. Any alternative ethical framework must still be arguable. The consequentialist who says "maximize utility" must presuppose self-ownership to make the argument. The virtue ethicist who says "cultivate excellence" must presuppose the right to cultivate. The divine command theorist who says "obey God" must presuppose the right to speak and advocate. Whatever the content of one's ethical theory, the act of proposing it presupposes the Hoppean framework.

### The Scope of the Argument

A potential objection asks how argumentation ethics applies to those who cannot argue: infants, the severely cognitively impaired, the temporarily unconscious. If rights derive from the presuppositions of argumentation, do non-arguers have rights?

The response is that every arguer was once such a person.^11^ Anyone engaged in argumentation must value the conditions that made their current capacity possible, including not being killed during the period when they lacked argumentative capacity but possessed the potential to develop it. To argue that potential arguers have no rights would be to contradict the conditions of one's own existence as an arguer. The preargumentation state is not outside the argument's scope but presupposed by it.

This book adopts Hoppe's argument as the normative foundation for privacy. The argument has withstood nearly four decades of critical scrutiny. Those who wish to reject it bear the burden of showing how they can do so without performative contradiction.

## 4.4 Implications: Property and Non-Aggression

If Hoppe's argument succeeds, the following conclusions follow:

### Self-Ownership

Individuals have exclusive rights over their own bodies and minds. Others may not use a person's body or interfere with their mental processes without consent. This includes bodily integrity (freedom from assault, battery, confinement), mental integrity (freedom from manipulation, coercion, psychological invasion), and expressive control (freedom to communicate or remain silent).

### Property Rights

Individuals acquire property rights in external resources through original appropriation (first use) and voluntary transfer (gift, exchange). Property rights include exclusive use (the owner decides how the resource is used), transfer (the owner can give or sell the resource), and exclusion (the owner can prevent others from using the resource).

### The Non-Aggression Principle

The initiation of force against persons or property is illegitimate. Force is justified only in defense against prior aggression. Taking property without consent is aggression. Harming persons without consent is aggression. Deception to obtain property or consent is aggression. Compelling someone to reveal information violates self-ownership.

### Privacy Implications

For privacy specifically, the argument establishes several protections. Mental privacy means thoughts, plans, and preferences are protected by self-ownership. Communication privacy means choosing what to reveal and to whom is an exercise of self-ownership. Data privacy means information about oneself, stored on owned media, is protected by property rights. Against coerced surveillance, forcing disclosure or monitoring without consent violates self-ownership.

## 4.5 What the Argument Establishes

The argumentation ethics framework establishes:

**Self-ownership is normatively justified.** The exclusive right to control one's body and mind is not an arbitrary preference but a presupposition of rational discourse itself. Denying self-ownership while arguing creates performative contradiction.

**Property rights follow from self-ownership and original appropriation.** To act, one must use external resources. The principle of first appropriation provides the only non-arbitrary, universalizable resolution to conflicts over resource use.

**The Non-Aggression Principle provides the ethical framework.** Uninvited interference with person or property violates the rights established above. Force is justified only in defense against prior aggression.

**Privacy is protected as an exercise of self-ownership and property rights.** Coerced surveillance is illegitimate aggression.

### Boundaries of the Argument

The argument applies most directly to coerced disclosure and nonconsensual monitoring. Complex cases require further analysis: surveillance by invitation or contract involves consent; observation of public behavior involves no trespass; inference from available information involves no forced disclosure. These cases do not refute the argument but require careful application of its principles.

The argument establishes a framework, not a complete casuistry. Like any ethical foundation, it must be applied to specific cases with judgment. What it provides is the criterion for such judgments: respect for self-ownership and property.

## Chapter Summary

Hoppe's argumentation ethics demonstrates that engaging in discourse presupposes self-ownership. Denying self-ownership while arguing creates performative contradiction: the denier must exercise exclusive control over body and mind to formulate and express the denial. From self-ownership, property rights and the Non-Aggression Principle follow. This provides the normative foundation for privacy: coerced surveillance violates self-ownership and is therefore illegitimate.

The argument has faced objections over nearly four decades. The use-ownership gap (Murphy and Callahan) asks whether Hoppe establishes ownership or mere use; the response shows that the distinction collapses under scrutiny and that refusing to acknowledge ownership places one outside rational discourse entirely. The is-ought question asks whether the argument bridges Hume's gap; the response shows that the argument does not derive ought from is but demonstrates that certain normative claims cannot be coherently denied. The partial application objection asks why principles established in argumentation apply outside it; the response shows that universalizability is constitutive of argumentation itself.

Additional defenses strengthen the framework: Kinsella's estoppel argument, the preargumentation defense for potential arguers, and van Dun's clarification that rejecting the argument's presuppositions places one outside the community of discourse rather than refuting the argument.

Privacy is normatively protected through self-ownership. This protection derives not from arbitrary preference but from the presuppositions of rational discourse itself. Anyone who would argue against this conclusion must first presuppose what they deny. The argument stands because no coherent refutation is possible without performative contradiction.

---

## Footnotes

^1^ Hans-Hermann Hoppe, "Argumentation Ethics," in *The Economics and Ethics of Private Property*, 2nd ed. (Auburn, AL: Ludwig von Mises Institute, 2006), 380.

^2^ On discourse ethics, see Jürgen Habermas, *Moral Consciousness and Communicative Action*, trans. Christian Lenhardt and Shierry Weber Nicholsen (Cambridge, MA: MIT Press, 1990); Karl-Otto Apel, "The Problem of Philosophical Foundations in Light of a Transcendental Pragmatics of Language," in *After Philosophy: End or Transformation?*, ed. Kenneth Baynes et al. (Cambridge, MA: MIT Press, 1987). For Hoppe's adaptation, see Hans-Hermann Hoppe, *A Theory of Socialism and Capitalism* (Boston: Kluwer Academic, 1989), ch. 7.

^3^ Robert P. Murphy and Gene Callahan, "Hans-Hermann Hoppe's Argumentation Ethic: A Critique," *Journal of Libertarian Studies* 20, no. 2 (2006): 53-64. Available at https://cdn.mises.org/20_2_3.pdf.

^4^ For responses to Murphy and Callahan, see Walter Block, "Rejoinder to Murphy and Callahan on Hoppe's Argumentation Ethics," *Journal of Libertarian Studies* 22 (2010): 631-639; Marian Eabrasu, "A Reply to the Current Critiques Formulated Against Hoppe's Argumentation Ethics," *Libertarian Papers* 1, no. 20 (2009).

^5^ Frank van Dun, "Argumentation Ethics and the Philosophy of Freedom," *Libertarian Papers* 1, no. 20 (2009). Van Dun's analysis clarifies that one who refuses to acknowledge the presuppositions of argumentation has not refuted the argument but placed themselves outside the community of rational discourse.

^6^ Hatim Kheir, "Bridging the Use-Ownership Gap: A Reformulation of Hoppe's Argumentation Ethics on Praxeological Grounds," *Journal of Libertarian Studies* 27, no. 1 (2023): 115-134. Available at https://jls.mises.org/article/84874.

^7^ On universalizability, see Hoppe, "Argumentation Ethics," 383-384; Stephan Kinsella, "Explaining Argumentation Ethics and Universalizability Concisely," (2019), available at https://stephankinsella.com/2019/03/explaining-argumentation-ethics-and-universalizability-concisely-to-a-facebook-friend/. The argument that particularistic norms are self-defeating in rational discourse derives from the Kantian tradition but receives distinctly libertarian application in Hoppe's framework.

^8^ On estoppel as a complementary justification for rights, see Stephan Kinsella, "Estoppel: A New Justification for Individual Rights," *Reason Papers* 17 (1992): 61-74. Kinsella argues that aggressors are estopped from objecting to defensive force because their own actions demonstrate acceptance of the principle that force is permissible.

^9^ See Kinsella's interpretation of Hoppe's structure: Stephan Kinsella, "Argumentation Ethics and Liberty: A Concise Guide," Mises Institute (2011). Available at https://mises.org/mises-daily/argumentation-ethics-and-liberty-concise-guide.

^10^ Murray N. Rothbard, "Beyond Is and Ought," *Liberty* 2, no. 2 (1988): 44-45. Rothbard stated that Hoppe "has managed to transcend the famous is/ought, fact/value dichotomy that has plagued philosophy since the days of the scholastics."

^11^ On the extension of argumentation ethics to potential arguers, see Patrick Tinsley, "Preargumentation Ethics and the Issue of Abortion," *Journal of Libertarian Studies* (2020). The argument holds that current arguers must value the conditions that made their own argumentative capacity possible, including protection during the period when they possessed potential but not actual argumentative capacity.
