# Chapter 5: The Axiom of Resistance

*"One who does not accept the axiom of resistance is contemplating an entirely different system than Bitcoin."*

Eric Voskuil^1^

## Introduction

This chapter presents the third foundation: the Axiom of Resistance. Unlike the preceding axioms, this is an assumption rather than a self-evident or normative claim. Eric Voskuil, in his analysis of Bitcoin's security model, states that it is "not accepted as a fact but deemed a reasonable assumption, due to the behavior of similar systems."^2^

The assumption is this: systems can be designed to resist external control. Cryptographic tools can make surveillance technically difficult. Mathematical properties can protect privacy in ways that political promises cannot. You can coherently deny this assumption; PayPal-type systems, which rely on central authority, are perfectly coherent objects of analysis. To reject the Axiom of Resistance is not to commit logical error; it is to analyze different systems.

But the assumption is well-grounded. It rests on mathematical foundations (computational hardness), empirical evidence (systems like Tor and Bitcoin have resisted control for years), and methodological necessity (if we want to analyze resistant systems, we must assume resistance is possible). This chapter examines what the axiom asserts, why it is well-grounded, and what its limitations are.

## 5.1 What the Axiom Asserts

### The Core Claim

The Axiom of Resistance asserts that it is possible to design systems that resist external control. Specifically, cryptographic systems can protect information from unauthorized access, decentralized networks can operate without single points of control, mathematical properties can provide stronger guarantees than legal or political protections, and resistance, while not guaranteed, is technically achievable.

### What "Resistance" Means

Resistance is the capacity to impose costs on adversaries attempting control. A system resists to the degree that circumventing its protections requires resources exceeding what adversaries are willing or able to expend. Resistance is not binary but exists on a spectrum: a system may resist casual attackers but not nation-states, or resist all known attacks but remain vulnerable to advances in mathematics or computing.

Several dimensions define resistance. First, computational resistance: cryptographic systems resist because breaking them requires computational resources that are practically unobtainable. A 256-bit key resists brute force because exhaustive search would require more operations than the age of the universe permits. Second, economic resistance: systems resist when the cost of attack exceeds the value of success. Even a breakable system resists if breaking it costs more than the information is worth to the attacker. Third, structural resistance: decentralized systems resist because there is no single point to attack. Taking down one node leaves others operating; compromising one participant does not compromise the network. Fourth, jurisdictional resistance: systems spread across legal jurisdictions resist because no single authority can compel compliance from all components. What is illegal in one territory may be legal in another.

Resistance is not invulnerability. No system is perfectly secure. The axiom claims that resistance is possible: systems can be designed such that overcoming them requires resources exceeding what attackers are willing to expend. Resistance is also asymmetric, meaning defenders can achieve protection at lower cost than attackers can achieve breach; encryption is cheap, while breaking strong encryption is expensive. This asymmetry shifts the balance of power. Without cryptographic protection, surveillance is easy and privacy is hard. With cryptographic protection, privacy becomes feasible and surveillance becomes costly.

### What the Axiom Does NOT Assert

The axiom does not claim that resistance is guaranteed; systems can fail, implementations can have bugs, and users can make mistakes, so the axiom assumes resistance is possible, not that it always succeeds. Nor does it claim that resistance is absolute, since states have resources individuals lack and can sometimes overcome resistance through legal compulsion, physical coercion, or massive resource expenditure when sufficiently motivated. The axiom does not claim that resistance solves all problems, as physical coercion, social engineering, and human error affect both costs and outcomes. Finally, unlike the Action Axiom, denial of resistance creates no logical contradiction; the axiom is assumed, not proven, and this distinguishes its logical status from the self-evident foundations examined in earlier chapters.

## 5.2 Why the Axiom Is Well-Grounded

Though an assumption rather than a proof, the Axiom of Resistance rests on substantial foundations.

### Mathematical Grounding

Modern cryptography rests on computational hardness assumptions. Certain mathematical problems appear to be fundamentally difficult to solve. Factoring large numbers presents one such challenge: given two large primes, multiplying them is easy, but given their product, finding the original primes is computationally infeasible with current technology. The discrete logarithm problem exhibits similar properties; in certain mathematical structures, computing a value is easy while reversing the computation is infeasible. Hash function preimage resistance provides another foundation: given a cryptographic hash output, finding an input that produces that output is computationally infeasible. These hardness assumptions underlie RSA, elliptic curve cryptography, and the hash functions used in Bitcoin and other systems. If the assumptions hold, the cryptographic protections are real.

The assumptions are not proven. If P equals NP, a question that remains open, most current cryptographic assumptions would collapse. The entire edifice of public-key cryptography rests on conjectures that, while well-supported by decades of failed attacks, have no mathematical proof of correctness.

Moreover, algorithmic progress continues. The General Number Field Sieve has improved factoring efficiency over earlier methods. Lattice-based attacks have weakened certain elliptic curve implementations. Quantum computing, discussed in Chapter 13, threatens to break most current public-key cryptography entirely. The security margins that seem comfortable today may narrow as mathematics and computing advance.

What decades of research have established is not that these problems are provably hard, but that no one has yet found efficient solutions. The assumptions are empirically well-grounded, not mathematically proven. This distinction matters: cryptographic security is contingent on the continued failure of attack research, not on demonstrated impossibility. Chapter 13 examines these computational foundations in detail.

### Empirical Track Record

Systems designed for resistance have demonstrated actual resistance. The Tor network, operating since 2002, has provided anonymous communication to millions despite state-level adversaries. While not perfect (timing attacks, compromised exit nodes, and user errors remain concerns), Tor has proven resistant to most surveillance for most users most of the time. Bitcoin, operating since 2009, has processed transactions and maintained consensus despite no central authority; attempts to shut it down have failed, and the network continues producing blocks without interruption. PGP and its descendants have protected communications for decades with strong encryption. Even when users have been prosecuted, courts have been unable to compel disclosure of encrypted content when keys were unavailable. Signal and other end-to-end encrypted messaging applications have protected private communications at scale.

This empirical record does not prove resistance will always succeed. But it establishes that resistance has succeeded in practice over extended periods against well-resourced adversaries.

### Methodological Necessity

Voskuil emphasizes that accepting the Axiom of Resistance defines what we are analyzing. "One who does not accept the axiom of resistance is contemplating an entirely different system than Bitcoin."

If you assume resistance is impossible, you are analyzing permissioned systems: PayPal, bank accounts, regulated financial institutions. These systems operate at the pleasure of authorities and can be shut down, modified, or surveilled at will.

If you assume resistance is possible, you are analyzing permissionless systems: Bitcoin, Tor, end-to-end encryption. These systems operate independently of authorities and resist control by design.

Both types of systems exist. Both are worthy of study. But they are different, and analysis appropriate to one may not apply to the other. The axiom is a methodological choice that defines the subject matter.

### Epistemic Problem with Denial

There is an epistemic peculiarity in denying the Axiom of Resistance.

If resistance is actually impossible, if states can control all information flows and overcome all cryptographic protection, then how would you know? Your sources of information would be controlled. Your ability to discover resistance possibilities would be limited. Your very belief that resistance is impossible might be a product of the control you think is total.

This is not a proof that resistance is possible. But it suggests that confident denial faces its own epistemic challenges. The denier cannot easily verify their denial without access to information that, if the denial is correct, they cannot trust.

## 5.3 Relationship to Other Foundations

### Action Axiom (Chapter 3)

The Action Axiom establishes that privacy is built into the structure of action. Deliberation is internal; preferences are subjective; information asymmetry is inherent.

The Axiom of Resistance asks: can this inherent property be protected? Can the privacy that exists as a fact of human action be preserved against attempts to eliminate it?

The Resistance Axiom assumes yes. Technical protection is possible. The structural privacy of action can be maintained through cryptographic means.

### Argumentation Axiom (Chapter 4)

The Argumentation Axiom argues (if sound) that privacy cannot be coherently denied in discourse. Self-ownership includes control over one's mental processes and communications.

But this normative conclusion is empty without implementation. Claiming that privacy should be protected does not make it protected.

The Axiom of Resistance bridges the gap between normative and practical. If resistance is possible, then the privacy that ought to be protected (per Chapter 4) can be protected (per Chapter 5).

### The Three Foundations Together

Together the three foundations provide what privacy is (inherent to action), why privacy matters (normative status), and how privacy is achieved (technical implementation).

## 5.4 Scope and Limitations

### What This Chapter Establishes

This chapter establishes that resistance is assumed, not proven; the axiom is a well-grounded assumption, not a demonstrated fact, and this is its proper logical status. The assumption is well-grounded because mathematical foundations, empirical track record, methodological necessity, and epistemic considerations all support it. The axiom defines the subject matter: accepting it means analyzing resistant systems, while rejecting it means analyzing permissioned systems.

### What This Chapter Does NOT Establish

This chapter does not establish that resistance always succeeds. Resistance often fails; the axiom claims possibility, not inevitability. Physical coercion (the "$5 wrench attack"), implementation vulnerabilities, user error, and insufficient network scale all cause resistance to fail in practice.

Nor does this chapter establish that resistance is costless. Costs vary by threat: digital resistance through cryptography makes defense cheap while attack is expensive, but physical coercion inverts this relationship, making compliance cheap while resistance becomes expensive. System design can shift costs through deniability, distributed control, and operational security, but costs remain.

This chapter does not establish that current systems are adequate. Systems must evolve as threats evolve, and today's security may be tomorrow's vulnerability. States possess resources individuals lack: legal authority to compel cooperation, intelligence agencies with significant capabilities, and power to compromise supply chains.

Finally, this chapter does not establish that the assumption is beyond question. It is an assumption, and reasonable people can reject it while analyzing different systems.


## Chapter Summary

The Axiom of Resistance is the third foundation: the assumption that systems can be designed to resist external control. As Voskuil formulates it: "not accepted as a fact but deemed a reasonable assumption, due to the behavior of similar systems."

The assumption is well-grounded. Mathematical foundations through computational hardness assumptions underlie modern cryptography. The empirical track record shows Tor, Bitcoin, and encryption tools have resisted control for years. Methodological necessity means the axiom defines the subject matter of analysis. Epistemic considerations reveal that denial faces its own epistemic challenges.

Resistance has costs. Physical coercion can be resisted but at high personal cost. Implementation failures undermine mathematical security. User error defeats technical safeguards. State resources raise the cost of successful resistance. Accepting these limitations while maintaining the core assumption enables the analysis of resistant systems that occupies the remainder of this book.

---

## Footnotes

^1^ Eric Voskuil, "Axiom of Resistance," *Cryptoeconomics: Fundamental Principles of Bitcoin*, available at https://github.com/libbitcoin/libbitcoin-system/wiki/Axiom-of-Resistance.

^2^ Voskuil, "Axiom of Resistance." The full quote: "The axiom is not accepted as a fact but deemed to be a reasonable assumption, due to the behavior of similar systems."

^3^ On computational hardness and cryptographic assumptions, see Jonathan Katz and Yehuda Lindell, *Introduction to Modern Cryptography*, 3rd ed. (Boca Raton: CRC Press, 2020), particularly chapters on computational security and hardness assumptions.

^4^ On the P vs NP problem and its implications for cryptography, see Scott Aaronson, *Quantum Computing Since Democritus* (Cambridge: Cambridge University Press, 2013), and Michael Sipser, *Introduction to the Theory of Computation*, 3rd ed. (Boston: Cengage Learning, 2012).

^5^ On Tor's security model and limitations, see Roger Dingledine, Nick Mathewson, and Paul Syverson, "Tor: The Second-Generation Onion Router," USENIX Security Symposium (2004). For ongoing analysis, see https://blog.torproject.org/.

^6^ On Bitcoin's security model, see Eric Voskuil, *Cryptoeconomics: Fundamental Principles of Bitcoin* (2020), particularly the sections on security models and economic assumptions.

^7^ On post-quantum cryptography, see NIST Post-Quantum Cryptography Standardization project, https://csrc.nist.gov/projects/post-quantum-cryptography. NIST released the first finalized post-quantum encryption standards in August 2024.

^8^ On implementation failures and their lessons, see Ross Anderson, *Security Engineering*, 3rd ed. (Indianapolis: Wiley, 2020), particularly the chapters on cryptographic implementation failures.
