# Chapter 6: Information, Scarcity, and Property

*"Ideas are not scarce resources."*

Stephan Kinsella^1^

## Introduction

What is the relationship between information and property? The answer determines how privacy can be protected. If information content can be property, privacy might be protected through property rights in information itself. If information content cannot be property, privacy must be protected through other means.

Stephan Kinsella's analysis provides the framework.^2^ Property rights apply only to scarce resources, those that one party's use precludes another's use. Information content, once known, can be used by unlimited parties simultaneously without depletion. It is non-scarce and therefore cannot be property.

This position, while consistent with Austrian methodology's emphasis on scarcity as the foundation of property, is not universally held even among Austrian economists. Some argue for utilitarian justifications of intellectual property (incentives for creation), while others propose alternative frameworks grounding IP in labor-mixing theories or contractual arrangements. The debate remains active. This chapter presents the Kinsella framework because it follows most directly from scarcity-based property theory, but readers should understand that intellectual property remains contested terrain even within the Austrian tradition.

This does not leave privacy unprotected. Privacy is protected through:
1. Self-ownership (control over one's body and mind)
2. Physical property (devices, papers, homes)
3. Contract (confidentiality agreements)

These mechanisms protect privacy without treating information content as property. Understanding this distinction is essential for clear analysis of privacy economics.

## 6.1 Scarcity as the Foundation of Property

### Why Property Rights Exist

Property rights exist to resolve conflicts over scarce resources. A scarce resource is one that, when used by one party, cannot simultaneously be used by another in the same way. Land, food, tools, and bodies are scarce: my use of this apple precludes your simultaneous use of the same apple.

Scarcity creates the potential for conflict. If multiple parties want to use the same resource in incompatible ways, they must either fight over it or agree on allocation rules. Property rights are allocation rules that assign control over resources to specific parties.

Without scarcity, property rights serve no purpose. If a resource can be used by everyone simultaneously without conflict, no allocation rules are needed.

### Physical Scarcity vs. Artificial Scarcity

Physical scarcity is inherent in the resource itself. Land is scarce because occupying one location precludes simultaneous occupation by another. Apples are scarce because eating one prevents anyone else from eating the same apple.

Artificial scarcity is imposed by external force on resources that are not inherently scarce. If I write a poem and you memorize it, you can recite it without diminishing my ability to recite it. The poem, as a pattern of words, is non-scarce. But if the state grants me a "copyright" enforced by violence, it artificially restricts your use of a non-scarce resource.

Property rights in physically scarce resources resolve real conflicts. "Property rights" in artificially scarce resources create conflicts that would not otherwise exist. They give one party control over how others may use their own legitimately owned physical resources.

### Rivalrous vs. Non-Rivalrous Use

Economists distinguish rivalrous from non-rivalrous goods. Rivalrous goods are those where one person's use prevents another's use; if I eat the sandwich, you cannot eat the same sandwich. Non-rivalrous goods are those where one person's use does not prevent another's use; if I know the Pythagorean theorem, you can know it too without diminishing my knowledge.

Information content is non-rivalrous. When you learn something I know, my knowledge is not reduced. The idea can be held by unlimited minds simultaneously.

This non-rivalrousness is fundamental. It means information content lacks the characteristic (scarcity) that property rights exist to address.

## 6.2 "Intellectual Property" as Aggression

Section 6.1 established that property rights exist to resolve conflicts over scarce resources, and that information content is non-scarce. The implication: "intellectual property" creates artificial scarcity through state violence, violating actual property rights in physical resources.

Consider a simple case. Alice invents a new mousetrap design. Bob independently develops the same design, or learns of it and implements it using his own materials.

If Alice has "intellectual property" in the design, she can use state violence to prevent Bob from using his own materials (wood, springs, wire) in certain configurations. The state will punish Bob for arranging his own property in ways Alice disapproves.

The claim constitutes aggression. Bob has done nothing to Alice or her property. He has used his own property. The "intellectual property" claim is a claim that Alice can control how Bob uses Bob's property, backed by state violence.

### The Patent Example

Patents grant monopolies on ideas. A patent holder can prevent anyone else from implementing the patented idea, even someone who invented it independently.

The patent holder controls how others may use their own physical property. Independent inventors have no defense because the first to file wins. Competition is restricted not by superior service but by legal privilege. Innovation is taxed, as anyone improving on patented ideas must pay tribute.

Patents are not property rights. They are monopoly privileges granted by the state, enforced by aggression against others' actual property.

### The Copyright Example

Copyright grants control over copying patterns. A copyright holder can prevent others from arranging their own physical property (paper, ink, hard drives) in certain configurations.

You cannot print certain patterns on your own paper. You cannot store certain bit patterns on your own hard drive. You cannot speak certain word sequences (in commercial contexts). Your physical property is controlled by others' claims to patterns.

Copyright is not property. It is censorship backed by state violence, restricting what you may do with your own property based on pattern similarity to patterns someone else claims.

## 6.3 Content vs. Media: The Critical Distinction

### Information Exists on Physical Media

Information is always instantiated on physical media. A book is paper and ink arranged in patterns. A hard drive contains magnetic domains in specific configurations. A brain contains neural patterns encoding memories and knowledge.

The media (paper, hard drive, brain) are scarce physical objects. The content (patterns, information, ideas) is non-scarce.

### Property Rights Apply to Media, Not Content

You own your paper. You can do anything with it: write on it, burn it, fold it into a hat. Your property rights are comprehensive.

You own your hard drive. You can store any bit patterns you want. Your property rights include determining what configurations your property takes.

But once you communicate content to another person, you cannot control what they do with their own media. If you tell me a secret and I write it in my notebook, you have no property claim to my notebook. The content, now in my mind and my notebook, is not your property.

### What "Owning Information" Would Mean

If information content were property, teaching would be transfer of property (do teachers lose their knowledge when students learn?), learning would be acquisition of property (from whom? with what consent?), memory would be storage of others' property (can they demand deletion?), and conversation would be property exchange (tracking who "owns" each idea discussed?).

These absurdities reveal that information-as-property is incoherent. Knowledge is not a thing that can be owned, lost, stolen, or transferred in the way physical objects can.

### The "Theft" Confusion

When someone copies your file without permission, have they "stolen" it?

No. You still have your file. Nothing has been taken from you. Your property is intact.

What has happened is that they have created new patterns on their own media, patterns similar to patterns on your media. This may violate contract if they had agreements with you. It may be wrong for other reasons. But it is not theft because nothing was taken.

The language of "stealing" ideas confuses the issue by importing property concepts where they do not apply.

## 6.4 How Privacy Is Actually Protected

If information content cannot be property, how is privacy protected? Through three mechanisms that do not require information-as-property claims.

### Self-Ownership

Chapter 4 argued that self-ownership follows from argumentation ethics. Self-ownership includes mental privacy, bodily integrity, and expression control. Your thoughts are yours, and no one has the right to extract them without consent. Your body is yours, and no one may examine, probe, or monitor it without consent. You choose what to communicate, and silence is always an option.

Self-ownership protects privacy at the source. Before information is communicated, it exists only in your mind and body, which are yours.

### Physical Property

You own your devices, papers, and home. Property rights include access control, search protection, and configuration control. You decide who may enter your property. Others may not examine your property without consent. You determine how your property is arranged, including what data your devices store.

Physical property rights protect information by protecting the media on which it exists. Your encrypted hard drive is your property. Others have no right to access it or compel you to decrypt it.

### Contract

Voluntary agreements can create enforceable obligations. Non-disclosure agreements bind parties not to reveal certain information. Employment or service contracts may include confidentiality clauses. Attorneys, doctors, and clergy operate under traditional professional privilege requiring confidentiality.

Contract protects privacy through voluntary commitment. When someone agrees to keep information confidential, they become bound by that agreement.

Breach of confidentiality agreements is not merely "breaking a promise." When payment is made under the condition of secrecy, revealing the secret constitutes theft of that payment. The money was transferred conditionally; accepting payment while violating the condition is taking money under false pretenses. This is fraud and theft, not merely breach of an abstract obligation. Contract violations have teeth because they involve transfers of scarce resources made under specific conditions.

### What These Mechanisms Do NOT Include

These mechanisms do not include property rights in information content itself, claims against people who independently discover the same information, rights to prevent others from using their own property in certain ways, or control over information after voluntary, unconditional disclosure.

If you tell a stranger your secret with no confidentiality agreement, you have no property claim to prevent them from sharing it. You controlled disclosure (self-ownership). You could have kept silent. Having chosen to speak, you cannot claim property rights in the patterns now in their mind.

## 6.5 Implications for Privacy Analysis

### What "Privacy Violation" Means

Given this framework, privacy violation is not simply someone knowing information you wish they did not know; that may be unfortunate but is not a violation. Privacy violation is someone accessing information through aggression against person or property.

Examples of violation include forcibly extracting information through torture or coerced testimony, trespassing to obtain information by breaking into home or device, breaching confidentiality contract which constitutes theft of conditional payment, and fraud to obtain information through impersonation or deception.

Examples of non-violation include observing someone in public, receiving information voluntarily shared, independently discovering information, and learning information from someone who was told without confidentiality agreement.

### The Role of Technology

Technology changes what is possible, not what is legitimate.

Encryption protects physical property (your devices) from search. This is an exercise of property rights, not a new right created by technology.

Anonymous networks protect self-ownership by enabling communication without revealing identity. This extends the natural privacy of in-person cash transactions to digital contexts.

Privacy technology implements existing rights. It does not create new rights or new categories of property.

### "Surveillance Capitalism" and Information Economics

When companies collect data about users, is this privacy violation?

It depends on the terms. If users agree to data collection (however unwisely) in exchange for services, no violation occurs: it is voluntary exchange. The exchange may be foolish, the terms may be buried in dense agreements, but consent was given.

If companies collect data without consent, through deception, or beyond the scope of agreements, this may violate contract or involve fraud.

But the data collected, once in the company's possession, is stored on their media. They own their servers. The information patterns on those servers are not "your property" that you can reclaim. The remedy for excessive data collection is not property claims but better contracts, competitive alternatives, and privacy-preserving technologies.

## Chapter Summary

Property rights apply to scarce resources. Information content is non-scarce: unlimited parties can hold the same idea without conflict. Therefore, information content cannot be property.

"Intellectual property" (patents, copyrights) creates artificial scarcity through state violence. It grants some parties control over how others may use their own physical property. This violates actual property rights.

Privacy is protected through self-ownership (your mind and body are yours, and you control what you reveal), physical property (your devices and papers are yours, and others cannot search them), and contract (voluntary agreements create enforceable confidentiality obligations). These mechanisms protect privacy without treating information as property. They protect the person and their property, not abstract patterns of information.

Understanding this distinction is essential for analyzing privacy economics. Chapters 7-9 apply this framework to exchange, capital theory, and monetary analysis, building the economic case for privacy on proper foundations.

---

## Footnotes

^1^ Stephan Kinsella, *Against Intellectual Property* (Auburn, AL: Ludwig von Mises Institute, 2008), 15.

^2^ Kinsella's fullest statement is *Against Intellectual Property*, originally published as "Against Intellectual Property," *Journal of Libertarian Studies* 15, no. 2 (2001): 1-53. See also his blog at stephankinsella.com for extensive elaboration and responses to critics.

^3^ On scarcity as the foundation of property, see Murray N. Rothbard, *The Ethics of Liberty* (New York: NYU Press, 1998), chapters 6-8, and Hans-Hermann Hoppe, *A Theory of Socialism and Capitalism* (Boston: Kluwer Academic, 1989), chapter 2.

^4^ On the economics of non-rivalrous goods, see Michele Boldrin and David K. Levine, *Against Intellectual Monopoly* (Cambridge: Cambridge University Press, 2008), which provides extensive empirical evidence that intellectual monopoly harms innovation.

^5^ On the distinction between property and privilege, see Rothbard, *The Ethics of Liberty*, chapter 10, and Lysander Spooner, "The Law of Intellectual Property" (1855), which argued for intellectual property but illuminates the issues.

^6^ On contract as the basis for confidentiality, see Randy Barnett, "A Consent Theory of Contract," *Columbia Law Review* 86 (1986): 269-321, and Kinsella's discussions of trade secrets in *Against Intellectual Property*.

^7^ On data and privacy in the digital age from a property-rights perspective, see various essays at mises.org and stephankinsella.com addressing "data ownership" and related concepts.
