# Chapter 8: Capital Theory and Entrepreneurship

*"Capital is produced means of production."*

Eugen von Böhm-Bawerk^1^

*"The entrepreneur is the driving force of the market economy."*

Israel M. Kirzner^2^

## Introduction

Privacy infrastructure is capital. It requires present sacrifice for future capability. Investment in encrypted communication systems, secure development environments, and anonymous networks yields enhanced coordination possibilities that direct approaches cannot achieve.

This chapter applies Austrian capital theory and entrepreneurship analysis to privacy. Böhm-Bawerk's insights about roundabout production explain why indirect methods of achieving privacy (building infrastructure) outperform direct methods (trusting institutions). Kirzner's entrepreneurial alertness explains how privacy innovations emerge through market discovery.

The analysis also illuminates a practical tradeoff: privacy often requires accepting inconvenience now for protection later. Time preference theory explains why some individuals invest in privacy infrastructure while others accept surveillance for immediate convenience. Neither choice is irrational; they reflect different preferences about present versus future satisfaction.

## 8.1 Privacy Infrastructure as Capital Goods

### Capital Goods vs. Consumer Goods

Praxeology distinguishes capital goods from consumer goods by their relationship to human wants:

Consumer goods satisfy wants directly; food satisfies hunger, shelter satisfies the need for protection, and entertainment satisfies the desire for enjoyment. Capital goods, by contrast, satisfy wants indirectly by enhancing future production. A factory does not satisfy wants directly; it produces goods that satisfy wants. A tool does not provide satisfaction directly; it enables work that produces satisfying outputs.

This distinction applies to privacy technology:

Privacy consumer goods include a single encrypted message that provides immediate privacy benefit, or a one-time anonymous purchase that protects an immediate transaction; these satisfy privacy wants directly. Privacy capital goods include an encrypted communication system that enables future private messages, a secure development environment that enables future privacy applications, and anonymous network infrastructure that enables future anonymous transactions. These do not provide immediate satisfaction; they enable future production of privacy benefits.

### Higher-Order and Lower-Order Goods

Menger classified goods by their distance from final consumption:^3^

First-order goods (consumer goods) directly satisfy wants. Second-order goods produce first-order goods. Third-order goods produce second-order goods, and so on, with each order enabling production at the next lower level.

Privacy infrastructure exhibits this hierarchical structure. Higher-order goods, distant from consumption, include cryptographic research, protocol development, and mathematical foundations. Middle-order goods include development frameworks, libraries, and secure communication protocols. Lower-order goods, close to consumption, include user applications, privacy services, and direct consultation.

Investment in higher-order goods yields greater returns but requires longer time horizons and greater patience. Cryptographic research may take years before producing consumer-facing applications.

### Roundabout Production

Böhm-Bawerk demonstrated that indirect (roundabout) production methods often yield superior results:^4^

The direct approach uses simple tools for immediate results; it is quick but limited in capability. The roundabout approach invests time building better tools; it is slower to start but yields superior long-term capability.

Privacy technology illustrates this principle. Direct privacy relies on institutional promises, legal frameworks, and trust relationships. It is quick to implement but vulnerable to authority changes, regulatory capture, and institutional compromise. Roundabout privacy builds cryptographic infrastructure enabling mathematical verification and proof systems. It is slower to develop but provides protection independent of institutional cooperation.

The roundabout approach requires lower time preference: willingness to sacrifice present convenience for future capability. But the results, privacy that does not depend on others' cooperation, justify the investment.

## 8.2 Time Preference and the Privacy-Convenience Tradeoff

### The Tradeoff

Privacy often requires inconvenience. Encrypted communication requires key management. Anonymous transactions require additional steps. Secure systems require learning curves.

This creates a real tradeoff: accept surveillance for immediate convenience, or accept inconvenience for future privacy protection.

Neither choice is inherently irrational. They reflect different time preferences, though time preference is not the only factor at work. Knowledge matters: users who do not understand surveillance risks cannot rationally weigh them. Convenience technologies often obscure their costs, making present benefits salient while hiding future risks. Social norms influence choices: if everyone uses surveilled services, privacy-protecting alternatives may lack network effects. Technical skill affects the cost of privacy: for users who find encryption easy, the tradeoff tilts toward privacy; for those who struggle, convenience weighs more heavily. Time preference remains central, but it interacts with information, skill, and social context.

### Time Preference Theory

Time preference is the preference for present satisfaction over future satisfaction. All else equal, people prefer goods now to goods later. A dollar today is worth more than a dollar next year.

But time preference varies among individuals:

Individuals with high time preference have a strong preference for present satisfaction and are willing to accept future costs for present benefits. Individuals with low time preference have a weaker preference for present satisfaction and are willing to accept present costs for future benefits.

### Application to Privacy

High time preference individuals may rationally choose surveillance-enabled services. The convenience is immediate and certain. The privacy costs are future and uncertain. Discounting future costs heavily, the trade favors convenience.

Low time preference individuals may rationally choose privacy infrastructure. The inconvenience is temporary as learning occurs. The privacy benefits compound over time. Valuing future benefits highly, the trade favors privacy.

This explains market segmentation in privacy technology. Some users adopt privacy tools despite inconvenience; others prefer convenient surveilled alternatives. Both are responding rationally to their own time preferences.

### Infrastructure Investment as Low Time Preference

Building privacy infrastructure requires even lower time preference than using privacy tools. Developers invest years before seeing adoption. Protocol designers work without immediate compensation. Open source contributors sacrifice present income for future impact.

This explains why privacy infrastructure development concentrates among individuals with unusually low time preference, often those with strong ideological commitment or unusual patience.

### Market Coordination of Time Preferences

Markets coordinate different time preferences:

Low time preference individuals build infrastructure. They accept present sacrifice for future capability, investing in tools, protocols, and systems.

High time preference individuals use infrastructure. They benefit from others' investment without sharing the development burden.

The dynamic is not free-riding; it is market specialization. Developers are compensated through eventual adoption, reputation, or satisfaction. Users pay through purchase prices, donations, or attention to advertising. Markets coordinate these different time preferences through voluntary exchange.

## 8.3 Entrepreneurial Discovery in Privacy

### Kirznerian Alertness

Israel Kirzner explained entrepreneurship as alertness to profit opportunities others miss:^5^

Entrepreneurs do not possess superior knowledge of given data. They notice opportunities that exist in the data but that others overlook. This alertness enables them to arbitrage between current market conditions and unrecognized possibilities.

Privacy technology exhibits Kirznerian discovery:

Entrepreneurs notice coordination problems. Existing tools fail to protect certain communications. Market participants cannot coordinate without surveillance. Institutional solutions leave gaps that technology could fill.

Entrepreneurs develop solutions. New protocols address unmet needs. Applications serve underserved markets. Infrastructure enables coordination previously impossible.

Entrepreneurs profit from alertness. Early adoption captures market position. Superior solutions attract users. Infrastructure investment creates competitive advantages.

### Discovery of Privacy Needs

Privacy needs are not always obvious. Many people do not recognize their privacy is compromised until harm occurs. Entrepreneurs notice these unrecognized needs:

Some needs involve latent demand: people would value privacy if they understood what they were losing, and entrepreneurs educate while serving. Other needs are unarticulated: people experience problems such as identity theft, embarrassing leaks, and chilling effects without connecting them to privacy, and entrepreneurs make the connection. Still other needs are future-oriented: surveillance capabilities will expand, and entrepreneurs anticipate problems before they become acute.

This discovery process explains why privacy technology often leads user demand instead of following it. Entrepreneurs see what users do not yet recognize.

### Creative Destruction

Schumpeter described innovation as creative destruction: new solutions displacing old ones, often destroying established businesses while creating new value.^6^

Privacy technology exhibits creative destruction. Encrypted messaging displaces SMS (less secure, more surveilled). Cryptocurrency displaces some payment systems (more surveilled, more controlled). Decentralized platforms compete with centralized ones (surveillance-enabled).

This destruction is creative because it serves users better. The displaced solutions were inferior; their displacement represents progress. But it is destructive for established interests that benefited from the old arrangements.

### Entrepreneurial Judgment Under Uncertainty

Peter Klein emphasizes that entrepreneurship involves judgment under uncertainty:^7^ decisions about resource allocation when outcomes cannot be known in advance.

Privacy entrepreneurs face substantial uncertainty. Will users adopt? Adoption depends on factors entrepreneurs cannot control. How will regulators respond? Legal environment may change. What will competitors do? Other entrepreneurs may develop superior solutions. Will the technology work? Implementation may reveal unexpected problems.

Entrepreneurial judgment involves committing resources despite this uncertainty. Successful entrepreneurs are not those who eliminate uncertainty but those who judge well amid it.

## 8.4 Capital Heterogeneity and Privacy Specialization

### Hayek on Capital Heterogeneity

Hayek demonstrated that capital goods are heterogeneous: different tools serve different purposes and cannot be arbitrarily substituted.^8^

A hammer is not interchangeable with a saw. A truck is not interchangeable with a ship. Each capital good has specific uses and capabilities.

This heterogeneity matters because investment decisions must match capital to purpose, misallocated capital cannot simply be reassigned, and coordination requires matching specific capitals to specific needs.

### Privacy Capital Specialization

Privacy infrastructure exhibits heterogeneous capital characteristics:

Cryptographic libraries serve application development but cannot substitute for user interface frameworks. Secure communication protocols enable messaging but cannot replace document storage systems. Anonymous networks provide routing but cannot substitute for identity management. Development environments enable application creation but cannot replace deployment infrastructure.

Each component serves specific functions. A well-developed cryptographic library does not compensate for poor user interface design. Strong protocols do not substitute for good operational security.

### Market Coordination of Heterogeneous Capital

Markets coordinate heterogeneous capital through price signals and entrepreneurial discovery:

Profit opportunities signal where capital is needed; high returns in a segment attract investment while low returns signal oversupply. Specialization enables expertise development as developers focus on specific components where they have comparative advantage. Exchange enables coordination between specialists, as those with cryptographic expertise trade with those having user interface expertise.

No central planner could coordinate this heterogeneous capital. The knowledge required, about specific capabilities, compatibility constraints, and market needs, is too dispersed. Only market processes can coordinate effectively.

## 8.5 Capital Formation and Privacy Development

### The Capital Formation Process

Capital formation requires savings (reduction of current consumption to free resources), investment (direction of freed resources toward capital goods), time (waiting for capital goods to produce returns), and maintenance (ongoing investment to preserve capital value). Privacy capital formation follows this pattern:

In the savings phase, developers forgo current income to invest in infrastructure development, and users forgo convenient surveilled services to invest in learning privacy tools. In the investment phase, resources flow into protocol development, application creation, and network building; time and effort produce capital goods. The time dimension is substantial: privacy infrastructure takes years to develop and deploy, and returns in the form of privacy protection emerge gradually. Finally, maintenance through ongoing development preserves security properties; code review, updates, and improvements maintain capital value.

### Open Source as Capital Formation

Open source development is a distinctive form of capital formation:

Open source involves collective investment, as many developers contribute without direct compensation to create shared capital. The resulting code is non-rivalrous capital: unlike physical capital, open source code can be used by unlimited parties without depletion. Competitive improvement accelerates capital formation as multiple developers enhance the same code base. Transparency also increases capital quality because open code enables security verification.

This mode of capital formation enables privacy infrastructure development that proprietary approaches could not match. The capital is collectively created, freely available, and continuously improved.

### Capital Accumulation and Privacy Capability

Capital accumulates through successful investment:

Individual accumulation occurs as developers who build successful tools can use them for future projects; expertise compounds and networks of collaborators develop. Ecosystem accumulation occurs as successful protocols enable new applications, infrastructure investment creates platforms for future development, and each layer enables additional layers. Knowledge accumulation occurs as solutions to past problems inform future development; lessons learned become embedded in practices and code.

This accumulation explains why privacy technology has improved dramatically over decades. Each generation builds on previous achievements, using accumulated capital for further advancement.

## Chapter Summary

Privacy infrastructure is capital in the Austrian sense: produced means of production that require present sacrifice for future capability. Higher-order privacy goods (cryptographic foundations, protocols) enable lower-order goods (applications, services) that serve user needs.

Time preference theory explains the privacy-convenience tradeoff. High time preference individuals rationally choose surveillance-enabled convenience; low time preference individuals rationally invest in privacy infrastructure. Markets coordinate these different preferences through specialization and exchange.

Entrepreneurial discovery drives privacy innovation. Alert entrepreneurs notice unmet privacy needs, develop solutions, and profit from serving markets others overlook. Creative destruction displaces inferior surveilled systems with superior privacy-preserving alternatives.

Capital heterogeneity means different privacy tools serve different purposes. Market coordination, through price signals and entrepreneurial discovery, allocates this heterogeneous capital more effectively than central planning could.

Capital formation in privacy technology occurs through individual investment, open source collaboration, and ecosystem accumulation. Each generation of development builds on previous achievements, applying accumulated capital for continued advancement.

---

## Footnotes

^1^ Eugen von Böhm-Bawerk, *Capital and Interest*, vol. 2: *Positive Theory of Capital*, trans. George D. Huncke and Hans F. Sennholz (South Holland, IL: Libertarian Press, 1959), 13-21.

^2^ Israel M. Kirzner, *Competition and Entrepreneurship* (Chicago: University of Chicago Press, 1973), 35-42.

^3^ Carl Menger, *Principles of Economics*, trans. James Dingwall and Bert F. Hoselitz (Auburn, AL: Ludwig von Mises Institute, 2007 [1871]), 55-67. Menger's theory of goods orders provides the foundation for Austrian capital theory.

^4^ Böhm-Bawerk, *Capital and Interest*, vol. 2, chapters 1-4; see also "The Roundabout Process in the Interest Theory," *Quarterly Journal of Economics* 21, no. 4 (1907): 529-590.

^5^ Kirzner, *Competition and Entrepreneurship*, 65-85. For development, see Kirzner, *Perception, Opportunity, and Profit: Studies in the Theory of Entrepreneurship* (Chicago: University of Chicago Press, 1979).

^6^ Joseph A. Schumpeter, *Capitalism, Socialism and Democracy*, 3rd ed. (New York: Harper & Row, 1950), 82-85.

^7^ Peter G. Klein, *The Capitalist and the Entrepreneur: Essays on Organizations and Markets* (Auburn, AL: Ludwig von Mises Institute, 2010), 1-35.

^8^ Friedrich A. Hayek, *The Pure Theory of Capital* (Chicago: University of Chicago Press, 1941), chapters 15-18; see also Hayek, *Individualism and Economic Order* (Chicago: University of Chicago Press, 1948), chapters 4-6.

^9^ On open source as economic phenomenon, see Eric S. Raymond, *The Cathedral and the Bazaar*, rev. ed. (Sebastopol, CA: O'Reilly Media, 2001), and Yochai Benkler, *The Wealth of Networks: How Social Production Transforms Markets and Freedom* (New Haven: Yale University Press, 2006).

^10^ Peter Lewin, *Capital in Disequilibrium: The Role of Capital in a Changing World* (London: Routledge, 1999), 85-112. Lewin demonstrates how capital formation fundamentally involves knowledge accumulation.
