# Chapter 9: Monetary Theory and Sound Money

*"Money is a medium of exchange."*

Ludwig von Mises^1^

## Introduction

Money is half of every exchange. Understanding money is essential for understanding markets.

This chapter develops Austrian monetary theory and its implications for privacy. Money emerges through market process, not government decree. Sound money has specific properties that enable economic calculation. Fiat money corrupts calculation and enables surveillance. Digital money offers possibilities for restoring soundness while preserving privacy.

The analysis here bridges economic theory (Part III) to technical implementation (Part V). Chapter 15 will examine Bitcoin specifically. This chapter establishes the theoretical framework for evaluating any monetary system, digital or otherwise.

## 9.1 The Market Origin of Money

### Menger's Discovery

Carl Menger demonstrated that money emerges through spontaneous market process.^2^ No government invented money. No social contract established it. Money arose through the independent actions of individuals seeking to facilitate exchange.

The problem is barter's double coincidence of wants. For direct exchange to occur, each party must want exactly what the other offers. A baker wanting shoes must find a shoemaker wanting bread. As economies develop and specialization increases, finding such coincidences becomes increasingly difficult.

The solution is indirect exchange. Individuals begin accepting goods they do not directly want but know they can trade further. A baker might accept cloth not to wear but because the shoemaker will accept cloth. The baker trades bread for cloth, then cloth for shoes, accomplishing through two exchanges what direct barter could not achieve.

### Emergence of Money

Certain goods prove especially useful for indirect exchange. Menger identified the property of "salability": how readily a good can be exchanged for other goods. Highly saleable goods become preferred media of exchange.

Salability depends on divisibility (can the good be divided for small transactions?), durability (does the good maintain value over time?), portability (can the good be transported efficiently?), and recognizability (can the good be readily identified and verified?).

Goods with superior salability, historically precious metals, become generally accepted media of exchange. Money emerges: not by decree but by market selection.

### Stages of Monetary Development

Menger identified a progression from direct barter (where exchange is limited by double coincidence of wants) through indirect exchange (where superior goods are accepted for further trade) to general acceptance (where the most saleable good becomes universally accepted) and finally to unit of account status (where money becomes the standard for pricing and calculation). This progression occurs through individual choices, not collective decision. Each person, seeking easier exchange, gravitates toward goods others will accept. The result is spontaneous convergence on money.

## 9.2 The Regression Theorem

### The Problem of Monetary Value

How does money acquire value? Ordinary goods are valued for their direct use. Money is valued for its exchange power. But exchange power depends on money's value. This seems circular.

Mises resolved this through the regression theorem:^3^ Money's current value depends on its expected future purchasing power, which depends on yesterday's purchasing power. The chain regresses to the point when the money commodity was valued for non-monetary uses.

Gold was valued for jewelry and ornament before it was money. Silver had industrial and decorative uses. Cattle served as food and labor before serving as money. Each successful money began as a commodity valued for direct use, then acquired additional monetary demand through its salability.

### Application to Novel Moneys

The regression theorem raises questions about new moneys that never had non-monetary use. If money must trace back to prior commodity value, how can a novel money emerge? This question has divided Austrian economists, and the debate remains unresolved.^4^

Some scholars argue that novel digital moneys cannot satisfy the theorem. On this view, money must emerge from a commodity with prior use-value; digital assets lacking physical commodity backing cannot become true money but only function as media of exchange built on top of existing fiat money.

The opposing view holds that the theorem's requirements are satisfied by subjective valuation of any kind. The subjective theory of value, foundational to Austrian methodology, holds that value exists only in the minds of valuing individuals. The theorem establishes that money's current value traces back to prior valuations, but those prior valuations themselves derive from individual subjective assessments, not from objective commodity properties. If first valuers had any reason for valuing, and that value was transmitted through market exchange, the regression chain can begin. Praxeology provides no basis for declaring some subjective valuations legitimate and others illegitimate.

A further interpretive point separates the theorem's explanatory power from metaphysical necessity. The theorem explains how money typically emerges through market process, demonstrating that monetary value need not be decreed by authority. It does not necessarily restrict which goods can become money if market participants choose to value them.

This book adopts the subjective value interpretation. But readers should understand that the question remains contested within Austrian economics, and thoughtful scholars disagree. The theorem's core insight, that money emerges through market process rather than decree, is not in dispute; the question is whether digital assets with no prior physical commodity use can satisfy the theorem's requirements or whether they represent a novel phenomenon that expands monetary theory. Chapter 15 applies this framework to Bitcoin specifically.

## 9.3 Sound Money Properties

Sound money has properties enabling it to serve economic coordination. These properties derive from money's functions, not from arbitrary preference.^5^

### Medium of Exchange

Money must be acceptable in trade. This requires recognizability, so that trading partners can verify authenticity without specialized equipment and counterfeiting remains difficult. It requires divisibility, enabling money to subdivide for transactions of any size, since indivisible money limits exchange. And it requires portability, allowing money to be transportable relative to its value; a high value-to-weight ratio enables larger transactions.

### Store of Value

Money must preserve value over time. This requires durability: physical money must resist degradation, and digital money must resist data loss. It requires scarcity, meaning supply must be predictable, since arbitrary inflation destroys the store-of-value function. And it requires resistance to confiscation, because money that can be easily seized offers poor storage.

### Unit of Account

Money must enable economic calculation. This requires stability, since value must be reasonably stable for prices to convey information and wild fluctuations corrupt price signals. It also requires fungibility: units must be interchangeable, because money with different values depending on history complicates calculation.

### Privacy Property

Transaction privacy is a sound money property often overlooked in standard treatments. As Chapter 7 established, exchange functions best when parties control disclosure; money that exposes all transactions distorts voluntary coordination. Money that enables third-party monitoring also enables third-party interference, so sound money resists such intrusion. Privacy further protects fungibility, since money whose units can be distinguished and discriminated against loses the interchangeability that calculation requires.

Physical cash exhibits privacy properties: transactions leave no automatic record. The absence of records is not a bug but a feature enabling voluntary exchange without surveillance.

## 9.4 Fiat Money and Its Problems

### What Fiat Money Is

Fiat money is money by government decree. It has no commodity backing. Its value derives from legal tender laws requiring its acceptance and from tax obligations payable only in fiat currency.

Modern fiat currencies (dollar, euro, yen) exemplify this: paper and digital entries with value because governments say so and enforce accordingly.

### The Inflation Problem

Fiat money enables unlimited supply expansion. Central banks create money at will, subject only to political constraints. This creates systematic problems.^6^

New money enters the economy through specific channels such as bank lending and government spending. First recipients spend at old prices; later recipients face inflated prices. This mechanism transfers wealth from later to earlier recipients. When prices rise unpredictably, businesses cannot distinguish genuine demand changes from monetary distortion, and resources flow to inflation-favored sectors rather than consumer-preferred uses, corrupting economic calculation. Inflation punishes savers whose purchasing power declines while rewarding debtors whose obligations shrink in real terms, thereby discouraging capital accumulation. Artificial credit expansion creates unsustainable booms followed by necessary busts; malinvestment during expansion must be liquidated during contraction, generating the business cycle.

### The Surveillance Problem

Fiat money in modern form is surveilled money. Digital fiat transactions are recorded, as banks maintain complete transaction histories. They are reported, since regulations require disclosure to government agencies. They are analyzable, with pattern analysis revealing personal information. And they are controllable, as accounts can be frozen and transactions blocked.

This surveillance capability has expanded dramatically through Know Your Customer (KYC) requirements, Anti-Money Laundering (AML) monitoring, automatic information sharing between jurisdictions, and increasing transaction reporting thresholds that capture ever more transactions.

The result: fiat money use generates comprehensive surveillance records. Privacy in economic life requires alternatives to surveilled fiat systems.

### The Control Problem

Fiat money enables economic control. Authorities can freeze accounts, preventing individuals from accessing their money. Specific payments can be blocked. Financial access can be denied entirely through deplatforming. Entire nations can be excluded from payment networks through sanctions.

This control can be used against criminals but also against dissidents, journalists, activists, and anyone disfavored by those with control. Fiat money is permission-based money: you may transact if authorities allow.

## 9.5 Free Banking vs. Central Banking

### The Free Banking Alternative

Free banking is competitive money and banking without central bank monopoly.^7^ Multiple banks issue their own notes, competing for customers based on reliability and service.

Historical examples (Scotland 1716-1845, Canada before 1935) suggest free banking systems were more stable than central banking, with fewer crises and better customer service. This assessment, associated particularly with Lawrence White and George Selgin, is contested within Austrian thought; Murray Rothbard and others favored 100% reserve banking over fractional reserve free banking.^10^ Market discipline prevented excessive risk-taking; banks that overissued lost customers to more conservative competitors.

Free banking preserves privacy through competition. Banks serve customers; customers who value privacy choose privacy-respecting banks. No single authority can impose surveillance across all financial activity.

### Central Banking Problems

Central banking replaces market competition with monopoly. A single point of failure emerges: one institution's errors affect the entire economy. Political capture follows, as monetary policy serves political ends instead of economic ones. Moral hazard develops when banks take excessive risks knowing central banks will bail them out. A single regulatory framework enables standardized surveillance and comprehensive monitoring.

The transition from competitive to central banking, completed in most countries by mid-twentieth century, represents a shift from market-based to politically controlled money, with corresponding privacy losses.

## 9.6 Money Proper vs. Money Substitutes

Austrian monetary theory distinguishes between money proper and money substitutes.^9^

**Money proper** is base money: the final means of payment requiring no further redemption. Gold coins in hand are money proper. You possess the value directly. No issuer exists to trust, no counterparty who must perform, no claim to be honored.

**Money substitutes** are claims against money proper. A bank note promising gold on demand is a money substitute. A bank account balance is a money substitute. The holder possesses not the money itself but a promise from an issuer.

Money substitutes carry counterparty risk. The holder must trust that the issuer exists, holds the reserves promised, will honor redemption requests, and cannot be prevented from honoring them. When issuers fail, are shut down, or refuse redemption, money substitutes become worthless regardless of whether the underlying money proper still exists.

This distinction matters for digital money. Every digital currency before Bitcoin was a money substitute: a claim against an issuer maintaining account balances. E-gold accounts were claims for gold held by a company. Liberty Reserve balances were claims against that company. DigiCash tokens were claims validated by a central server. When these issuers were shut down, users lost everything. The failure was inherent: money substitutes require trusted issuers, and trusted issuers are vulnerable.

The challenge for sound digital money: can a digital asset be money proper, not a money substitute? Can it be the thing itself, not a claim?

### The Current Monetary Architecture

The money proper/money substitutes distinction illuminates today's fiat monetary structure.

Base money (money proper) exists in two forms. Physical cash is base money that the general public can hold directly. Central bank reserves are also base money, but they are accessible only to commercial banks and governments. Ordinary citizens cannot open accounts at the Federal Reserve or European Central Bank.

What citizens hold in bank accounts is not base money but money substitutes: claims against commercial banks. Your bank balance is an IOU from the bank, not base money itself. This is why bank failures destroy depositors' balances even though the underlying base money still exists.

This architecture creates a buffer between state and citizen. The central bank issues base money to commercial banks; commercial banks issue money substitutes to citizens. Citizens interact with the monetary authority only indirectly, through private institutions. Chapter 10 examines how Central Bank Digital Currencies would eliminate this buffer by giving citizens direct base money balances at the central bank, with profound implications for surveillance and control.

## 9.7 Digital Money Requirements

What would sound digital money require? Austrian monetary theory suggests several criteria.^8^

Sound digital money requires decentralized verification: solving the double-spending problem without trusted third parties, with no single point that can be captured, corrupted, or coerced, and verification distributed among participants rather than concentrated in central authority.

Digital scarcity through rivalrousness is essential for property rights to apply. Units must be rivalrous, meaning one person's possession excludes another's. Physical goods are naturally rivalrous, but digital information is not. Solving double-spending creates rivalrousness: if the same token cannot be spent twice, possession becomes exclusive, and only then can property rights emerge. Without rivalrousness, digital tokens remain information, freely replicable and incapable of serving as property.

Distinct from scarcity itself is the requirement for transparent and immutable supply. Sound digital money requires that total supply and issuance rules be transparent (visible to all), verifiable (anyone can independently confirm), and not subject to unilateral change by any third party. This differs from fiat money where supply decisions are opaque and policy changes at central bank discretion. Transparency enables rational economic calculation in ways that opaque monetary policy cannot.

User-defined rules invert the traditional model where money systems impose rules from above and users comply or exit entirely. In sound digital money, each participant defines, verifies, and enforces the rules they accept. Running a full node means validating every transaction against self-chosen rules. Consensus emerges from participants independently converging on compatible rules, not from authority imposing uniformity. The rules are what the network actually enforces, not what some authority declares. Changes require convincing users to adopt new software; the default is the status quo.

Sound digital money also requires permissionless access, where anyone can use the money without approval and no gatekeeper controls access, preventing the deplatforming and control that characterize fiat systems. Transaction privacy means that while verification must be possible, surveillance should not be automatic, and users control what transaction information is revealed and to whom. Censorship resistance ensures transactions execute based on protocol rules rather than third-party permission, so no authority can block legitimate transactions. Finally, voluntary adoption means sound digital money emerges through market process rather than legal mandate, with users adopting based on superior properties and validating value through voluntary exchange.

## 9.8 Bridge to Bitcoin

Chapter 15 will examine Bitcoin as an implementation of these requirements. Here we note the basic contours of that analysis.

Bitcoin attempts to satisfy monetary theory requirements through decentralized verification via proof-of-work consensus, digital scarcity through solving double-spending, transparent and immutable supply through protocol rules enforced by every node, and user sovereignty through each participant independently validating the rules they accept. Bitcoin does have privacy limitations: basic Bitcoin transactions are pseudonymous but not anonymous, chain analysis can link transactions to identities, and privacy requires additional tools discussed in Chapter 15.

Chapter 15 also develops the regression theorem analysis for Bitcoin specifically, examining how the subjective value framework applies to its emergence as money.

## Chapter Summary

Money emerges through market process, not government decree. Menger demonstrated that individuals, seeking to overcome barter's limitations, naturally converge on goods with superior salability. This spontaneous emergence explains money's origin without requiring central planning or legal mandate.

Sound money has properties derived from its functions: recognizability, divisibility, portability, durability, scarcity, and resistance to interference. Transaction privacy is also a sound money property, enabling the voluntary exchange that markets require.

Fiat money creates systematic problems. Unlimited supply expansion transfers wealth, corrupts calculation, destroys savings, and generates business cycles. Modern fiat is also surveillance money, generating comprehensive transaction records that enable monitoring and control.

The distinction between money proper and money substitutes illuminates the current monetary architecture: physical cash is the only base money citizens can hold directly, while central bank reserves are accessible only to banks and governments. Citizens hold money substitutes (claims on commercial banks), creating a buffer between state and citizen that Chapter 10 examines in detail.

Digital money can potentially restore soundness. Requirements include decentralized verification, digital scarcity through rivalrousness, transparent and immutable supply, user-defined rules, permissionless access, transaction privacy, and censorship resistance. Bitcoin attempts to satisfy these requirements, though with limitations particularly regarding privacy.

The regression theorem question for novel money is resolved by recognizing that subjective value theory accommodates any reason for valuation. The theorem explains how money typically emerges, not that commodity backing is metaphysically necessary. Chapter 15 develops this analysis for Bitcoin specifically.

---

## Footnotes

^1^ Ludwig von Mises, *Human Action: A Treatise on Economics*, Scholar's Edition (Auburn, AL: Ludwig von Mises Institute, 1998), 398.

^2^ Carl Menger, "On the Origin of Money," *Economic Journal* 2, no. 6 (1892): 239-255. See also Menger, *Principles of Economics*, trans. James Dingwall and Bert F. Hoselitz (Auburn, AL: Ludwig von Mises Institute, 2007 [1871]), chapter 8.

^3^ Ludwig von Mises, *The Theory of Money and Credit*, trans. H.E. Batson (Indianapolis: Liberty Fund, 1981 [1912]), 97-123. See also Mises, *Human Action*, 408-416.

^4^ For skeptical views on Bitcoin and the regression theorem, see Frank Shostak, "The Bitcoin Money Myth," *Mises Daily* (April 17, 2013). For defenses of Bitcoin's compatibility with the theorem, see Peter Šurda, "Economics of Bitcoin: Is Bitcoin an Alternative to Fiat Currencies and Gold?" (master's thesis, Vienna University of Economics and Business, 2012); Konrad Graf, "On the Origins of Bitcoin: Stages of Monetary Evolution" (2013); Eric Voskuil, "Regression Fallacy," *Cryptoeconomics* (2020), available at https://github.com/libbitcoin/libbitcoin-system/wiki/Regression-Fallacy. For a recent synthesis, see Laura Davidson and Walter Block, "Bitcoin, the Regression Theorem, and the Emergence of a New Medium of Exchange," *Quarterly Journal of Austrian Economics* 18, no. 3 (2015): 311-338.

^5^ On sound money properties, see Mises, *The Theory of Money and Credit*, Part I; Murray N. Rothbard, *What Has Government Done to Our Money?*, 5th ed. (Auburn, AL: Ludwig von Mises Institute, 2010), chapters 1-3.

^6^ On fiat money problems, see Rothbard, *What Has Government Done to Our Money?*; Jörg Guido Hülsmann, *The Ethics of Money Production* (Auburn, AL: Ludwig von Mises Institute, 2008); Hans-Hermann Hoppe, "How Is Fiat Money Possible? or, The Devolution of Money and Credit," *Review of Austrian Economics* 7, no. 2 (1994): 49-74.

^7^ On free banking, see Lawrence H. White, *Free Banking in Britain: Theory, Experience and Debate, 1800-1845*, 2nd ed. (London: Institute of Economic Affairs, 1995); George A. Selgin, *The Theory of Free Banking* (Lanham, MD: Rowman & Littlefield, 1988).

^8^ For application of Austrian monetary theory to digital money, see Saifedean Ammous, *The Bitcoin Standard: The Decentralized Alternative to Central Banking* (Hoboken, NJ: John Wiley & Sons, 2018); Eric Voskuil, *Cryptoeconomics: Fundamental Principles of Bitcoin* (2020).

^9^ On money proper vs. money substitutes (also called fiduciary media), see Mises, *The Theory of Money and Credit*, Part II, chapters 1-3; also Mises, *Human Action*, 432-444.

^10^ For the Rothbard critique of fractional reserve free banking, see Murray N. Rothbard, *The Mystery of Banking*, 2nd ed. (Auburn, AL: Ludwig von Mises Institute, 2008), and "The Case for a 100 Percent Gold Dollar," in *In Search of a Monetary Constitution*, ed. Leland Yeager (Cambridge, MA: Harvard University Press, 1962). The debate between 100% reserve advocates (Rothbard, Jesús Huerta de Soto) and fractional reserve free bankers (White, Selgin) remains unresolved within the Austrian tradition.
