# Chapter 10: Financial Surveillance and State Control

*"The State is an organization of the political means."*

Franz Oppenheimer^1^

## Introduction

This chapter analyzes state intervention in financial activity using Murray Rothbard's intervention typology.^2^ Rothbard distinguished three categories: autistic (commands to individuals), binary (state as party to exchange), and triangular (state imposing on third-party exchanges). This framework illuminates how states surveil and control through finance, culminating in Central Bank Digital Currencies that combine all three intervention types.

## 10.1 Intervention Theory: Autistic, Binary, Triangular

### Rothbard's Framework

Rothbard developed a systematic typology of government intervention in *Power and Market*.^2^ All intervention involves the use or threat of violence to alter behavior that would otherwise occur in unhampered markets.

Autistic intervention involves commands directed at individuals without any exchange taking place. (Rothbard uses "autistic" in its technical economic sense, derived from Mises, meaning self-contained or non-exchange action, not in any psychological sense.) The state orders: do this, do not do that. No transaction occurs; the individual is simply commanded. Examples include conscription, compulsory schooling, and prohibitions on consumption.

Binary intervention involves the state as a party to an exchange, typically involuntary from the other party's perspective. Taxation is the classic case: the state takes wealth from individuals, giving nothing in return that the individual would have voluntarily purchased. Asset seizure, eminent domain, and confiscation are binary interventions.

Triangular intervention involves the state imposing on exchanges between third parties. The state is not a party to the transaction but dictates its terms. Price controls, licensing requirements, and mandatory contract terms are triangular interventions. The state forces or forbids exchanges it does not participate in.

### Application to Financial Privacy

This framework illuminates financial surveillance. Autistic intervention encompasses commands regarding privacy behavior, such as encryption bans or prohibitions on anonymous transactions. Binary intervention involves state extraction of information or assets through subpoenas, seizures, and compelled disclosure. Triangular intervention imposes mandates on private transactions, such as KYC requirements forcing banks to collect customer information before providing services.

Most financial surveillance operates through triangular intervention. The state does not directly surveil citizens (which would require resources and face constitutional constraints). Instead, it forces private institutions to surveil on its behalf, bearing the costs while providing the data.

## 10.2 Autistic Intervention and Privacy

### Direct Criminalization

Autistic intervention in privacy takes the form of direct prohibitions on tools and behaviors.

Encryption restrictions exemplify this category. Various jurisdictions have banned or restricted strong encryption. The classification of cryptographic software as "munitions" under U.S. export controls (until 1996) treated mathematical algorithms as weapons requiring government permission to share. Some nations continue restricting encryption strength or requiring key escrow.

Laws criminalizing anonymous purchases above certain thresholds represent another form of autistic intervention. The individual is commanded: you may not transact anonymously. No exchange with the state occurs; the prohibition is direct.

Proposals to ban privacy coins, coinjoining services, or anonymous communication tools are also autistic interventions. The state commands: do not possess or use these tools.

### Economic Analysis

Autistic intervention in privacy faces inherent limitations. The state cannot easily detect privacy tool usage without the surveillance it seeks to impose; encryption looks like random data, and its presence is deniable. Direct prohibition requires identifying violators, which requires the surveillance capability that privacy tools defeat; the intervention is self-undermining. Digital tools cross borders, so prohibition in one jurisdiction shifts activity instead of eliminating it.

These limitations explain why states prefer triangular intervention for financial surveillance. Direct prohibition is resource-intensive and often ineffective against technically sophisticated users.

## 10.3 Binary Intervention and Privacy

### State as Extracting Party

Binary intervention places the state as a party to involuntary exchange, extracting from individuals instead of imposing on third-party transactions.

Civil asset forfeiture enables seizure without criminal conviction. Property is accused of connection to crime; the owner must prove innocence to recover assets. This binary intervention extracts wealth while creating chilling effects on financial privacy.

Court orders compelling individuals to reveal passwords, encryption keys, or account information represent another form of binary intervention. The state extracts information directly, using contempt sanctions to coerce compliance.

Government demands for records held by individuals (as opposed to third-party reporting requirements) are also binary interventions. The individual must surrender information to the state.

While taxation itself is binary (the state takes, the individual receives nothing), compliance requirements impose additional binary burdens. Individuals must disclose financial information to demonstrate compliance, revealing private activity regardless of tax liability.

### Resistance and Limits

Binary intervention faces the target directly. Unlike triangular intervention operating through intermediaries, binary intervention requires the state to identify, locate, and coerce specific individuals.

In some jurisdictions, direct government extraction faces procedural requirements (warrants, probable cause) that triangular intervention circumvents. The Fourth Amendment constrains what the state can demand directly but not what third parties collect and report.

Compelling disclosure of encrypted data faces the practical problem that compliance cannot be verified. If the defendant claims to have forgotten a password, proving otherwise requires demonstrating knowledge that, if the state possessed, would make compulsion unnecessary.

Properly implemented encryption resists binary intervention entirely. The state can demand keys, but if keys were never stored or are forgotten, the demand cannot be satisfied. The Axiom of Resistance operates in practice here.

## 10.4 Triangular Intervention and Privacy

### The Preferred Mechanism

Triangular intervention is the primary mechanism of financial surveillance. Rather than directly commanding individuals or extracting from them, the state imposes on private transactions, forcing parties to modify their exchanges.

The Bank Secrecy Act of 1970 exemplifies this mechanism. Despite its name, the BSA destroyed bank secrecy by requiring financial institutions to maintain records and report transactions. Banks must file Currency Transaction Reports (CTRs) for cash transactions over $10,000 and Suspicious Activity Reports (SARs) for transactions that "might signify" illegal activity.^3^ This is triangular intervention: the state imposes on bank-customer relationships it is not party to. The bank must surveil customers; customers must submit to surveillance to access banking.

Know Your Customer mandates force financial institutions to collect and verify customer identity before establishing relationships. The customer-bank exchange is conditioned on information disclosure to satisfy government requirements. KYC creates comprehensive identity databases: government-issued identification, proof of address, source of funds, beneficial ownership. This information serves surveillance, not the bank's commercial interest. Banks would prefer simpler, less costly customer relationships; KYC is imposed externally.

Third-party reporting requirements compel financial institutions to report to government agencies: CTRs, SARs, FATCA filings for foreign accounts, Form 1099s for income. The individual's financial activity is reported without their consent, often without their knowledge.

### Monopoly Grants as Triangular Intervention

Monopoly, in the praxeological sense, is a grant of exclusive privilege by the state, not merely a dominant market position achieved through superior service. Rothbard distinguished between market dominance (where a single seller emerges through voluntary exchange) and monopoly privilege (where the state prohibits competition). Only the latter is monopoly proper.

Financial surveillance relies on monopoly grants. Banking licenses restrict who may accept deposits, creating a cartel that must obey surveillance mandates to maintain its privilege. Payment network regulations restrict who may transmit money, ensuring all major pathways are surveilled. Legal tender laws require acceptance of state currency, channeling transactions through monitored systems. Each monopoly grant creates leverage: the state offers exclusive privilege, and the price is surveillance compliance.

This explains why privacy-preserving alternatives face legal attack. Bitcoin threatens the currency monopoly. Unlicensed money transmission threatens the payment monopoly. Privacy coins threaten the surveillance infrastructure built on these monopolies. The legal response is predictable: extend monopoly protections to exclude competition.

### Why States Prefer Triangular Intervention

Triangular intervention offers advantages over autistic and binary approaches.

Banks bear surveillance costs; compliance infrastructure (personnel, technology, reporting systems) is privately funded but serves government objectives. Major banks spend billions annually on compliance, and these costs are ultimately borne by customers and shareholders.

Information collected by private parties under commercial authority faces fewer legal protections than information the government collects directly. Third-party doctrine holds that information shared with private parties loses constitutional protection.

Banks serve millions of customers, so forcing banks to surveil achieves comprehensive coverage that direct government surveillance could not match.

Rothbard observed that interventions create problems requiring further intervention.^4^ Initial reporting requirements revealed gaps, necessitating enhanced customer identification, which revealed more gaps, necessitating transaction monitoring systems, which generate false positives requiring investigation protocols, and so on. The BSA's evolution exemplifies this cascade. What began as currency transaction reporting in 1970 has expanded through subsequent legislation (MLCA 1986, USA PATRIOT Act 2001, CDD Rule 2016) into comprehensive financial surveillance infrastructure.

### Economic Effects

Triangular intervention distorts the transactions it targets.

Resources devoted to surveillance (personnel, technology, legal, reporting) are unavailable for productive activity. This is a deadweight loss: surveillance does not create value for the parties to the transaction.

Banks, facing regulatory risk from "suspicious" customers, deny services to entire categories: cryptocurrency businesses, cannabis companies, politically disfavored groups. The intervention cascades into complete exclusion from financial services.

Knowledge of surveillance alters behavior. Market participants avoid legitimate transactions that might trigger reports. Economic coordination suffers as parties avoid flagged activities.

Financial privacy disappears as comprehensive transaction records accumulate in government databases. The "financial panopticon" makes economic activity legible to state observation.

## 10.5 Central Bank Digital Currencies as Total Intervention

### From Triangular to Direct Intervention

Chapter 9 established that today's monetary architecture interposes commercial banks between citizens and base money. Citizens hold money substitutes (claims on banks), not base money itself. This buffer forces the state to work through intermediaries: banks collect data under regulatory compulsion, and the state accesses it through legal process. Financial surveillance currently operates primarily through triangular intervention.

CBDCs would eliminate this indirection. As Chapter 9 explained, CBDCs give citizens digital base money directly at the central bank, bypassing commercial banks entirely. From an intervention perspective, this transformation is decisive: the state no longer needs third parties to compel. The central bank *is* the bank. Every citizen's monetary existence becomes a direct account relationship with the state.

This changes the economics of intervention fundamentally. Observation requires no subpoenas; the state reads its own ledger. Control requires no regulatory mandates; the state administers its own system. The costs and frictions of triangular intervention vanish. What required legal process, institutional compliance, and enforcement resources now happens automatically.

### Total Intervention

Central Bank Digital Currencies combine all three intervention types into a unified control mechanism. CBDCs are programmable money enabling comprehensive surveillance and control, not simple digital versions of existing currency.^5^ Programmability is a design choice, not an inherent feature of digital currency. A CBDC could be designed to replicate cash's properties: anonymous, bearer-based, and free of spending restrictions. That central banks consistently choose surveillance-enabling designs reflects institutional incentives, not technical necessity. The designs being deployed and piloted reveal the intended use.

CBDC rules can prohibit transactions directly through what amounts to autistic intervention embedded in the monetary infrastructure. The currency itself refuses to execute disfavored payments. Prohibitions on anonymous transactions, purchases of restricted goods, or payments to blacklisted recipients become automatic. No prosecution is needed; the transaction simply fails.

Because CBDCs establish direct central bank accounts for citizens, they enable binary intervention without third-party collection: the state extracts transaction data directly, and every economic act is reported instantly to the monetary authority. There is no subpoena to issue, no bank to compel, no delay between transaction and observation. The state sees immediately because the state is the counterparty to every balance.

CBDCs also impose on private transactions through triangular intervention, requiring merchants to accept programmable currency, to verify customer compliance status before transacting, and to enforce spending restrictions. The state controls exchanges it is not party to through the monetary medium itself.

### Programmable Control

CBDC programmability enables interventions impossible with physical cash or current digital money.

Money can be programmed to expire, forcing spending and preventing saving; this implements negative interest rates without the zero lower bound. Money can be programmed to work only in specified regions, so that a welfare payment might spend only at approved vendors or a regional stimulus might not leave the targeted area. Money can refuse purchase categories, blocking payments for alcohol, tobacco, firearms, or politically disfavored goods at the monetary level. Transactions can require verified identity of both parties, making anonymous exchange impossible and ensuring every transaction is attributed. Money can be programmed to activate only when conditions are met: vaccination status, social credit score, tax compliance, political loyalty tests.

### The Two-Tier Illusion

Some central banks propose "two-tier" CBDC designs that maintain commercial banks as customer-facing intermediaries, claiming this preserves the existing architecture. This framing is misleading.

In a two-tier CBDC, commercial banks operate accounts and process transactions, but the central bank maintains the authoritative ledger. The commercial bank becomes a front-end interface, not an actual intermediary. The buffer that Chapter 9 identified, where citizens hold claims on commercial banks rather than direct central bank liabilities, is eliminated regardless of which institution operates the customer service desk.

The central bank sees every transaction because every transaction settles on its ledger. The central bank can program restrictions because the money is its liability. The central bank can freeze accounts because the balances are ultimately its entries. Commercial banks in a two-tier CBDC are service providers operating within parameters the central bank defines, not independent institutions creating actual money substitutes. The surveillance and control capabilities remain intact; only the user interface is delegated.

### The Adoption Mechanism

Praxeological analysis reveals why explicit prohibition is unnecessary for CBDC adoption.

Autistic intervention (banning cash) is costly: it requires enforcement, generates resistance, and makes the control objective visible. The state has strong incentive to achieve the same outcome through less resistant means. If citizens adopt CBDCs voluntarily, enforcement costs vanish and political opposition never mobilizes.

The incentive structure favors voluntary adoption. CBDCs can offer real conveniences: instant settlement, integration with government services, smartphone accessibility. For individuals with high time preference, immediate convenience outweighs abstract future risks. Revealed preference in existing digital payment adoption demonstrates that most individuals choose convenience over privacy when the tradeoff is not salient. The state need only ensure CBDCs are more convenient than alternatives.

Network effects create path dependency. As CBDC adoption increases, cash-handling infrastructure becomes less economical. Banks face costs maintaining cash services for declining usage; merchants face costs handling physical currency for fewer transactions. Each actor, pursuing their individual interest, rationally reduces cash infrastructure. The aggregate effect is that cash becomes progressively less practical regardless of legal status.

This dynamic has historical precedent. Sweden's cash usage declined from 40% of transactions in 2010 to under 10% by 2020 without legal prohibition, driven by payment system convenience and resulting infrastructure contraction. The economic logic operates independently of CBDC specifics.

The endpoint follows from the logic: when cash infrastructure contracts beyond practical usability, CBDC usage becomes mandatory in effect though voluntary in form. Surveillance that individuals chose for convenience becomes surveillance they cannot escape without exiting the national currency entirely.

The Human Rights Foundation tracks this progression globally. As of 2025, over 130 jurisdictions are researching, piloting, or deploying CBDCs, though these activities differ substantially.^6^ Research and study are widespread, but full deployment remains limited. Most jurisdictions are in exploratory phases, running pilots with limited participation or studying technical feasibility. The distinction matters: research does not commit a jurisdiction to deployment, and many pilot programs are discontinued. Several authoritarian regimes have launched retail CBDCs, with China's digital yuan the most prominent example, while democratic nations generally proceed more cautiously. The Foundation estimates that 3.7 billion people live under autocracies currently experimenting with CBDCs.

### The Surveillance Endpoint

CBDCs represent the culmination of financial surveillance. Every payment, to any party, for any amount, is recorded and attributed; the comprehensive financial history envisioned by earlier surveillance programs becomes automatic. Unlike post-hoc reporting, CBDC transactions are visible immediately, so intervention can occur before completion rather than after detection. If CBDCs become mandatory and cash is eliminated, no unsurveilled economic activity remains; underground economies must develop alternative currencies entirely.

Sound money requirements from Chapter 9 therefore include censorship resistance and privacy. Money that can be surveilled and controlled is not sound money; it is a mechanism of intervention.

## 10.6 The Adversarial Decision Cycle

### State Surveillance Follows the OODA Pattern

Chapter 1 introduced John Boyd's OODA loop: Observe, Orient, Decide, Act. Every intervention examined in this chapter follows this pattern.

Financial surveillance infrastructure exists to enable observation: CTRs report cash transactions, SARs flag suspicious activity, KYC requirements collect identity documents, third-party reporting creates transaction records. The Bank Secrecy Act and its successors are fundamentally about observation. Without observation, subsequent stages cannot proceed.

Observation feeds orientation, where raw data becomes actionable intelligence through pattern correlation, suspicious indicator evaluation, and target identification. KYC data becomes useful here: linking transactions to identified individuals enables the orientation that anonymous transactions would prevent. Orientation produces prioritized targets for decision, where finite resources are allocated among potential investigations. Finally, action takes the form of asset seizure, prosecution, regulatory sanction, or account closure, but action is only possible against identified targets whose behavior has been observed, analyzed, and selected. The entire apparatus of enforcement depends on the preceding stages.

### Breaking the Loop at Observation

Privacy technology breaks this cycle at its most vulnerable point. If the state cannot observe, it cannot orient on patterns it does not see, cannot decide to investigate transactions it does not know occurred, cannot act against targets it cannot identify.

Consider the contrast between traditional banking and properly implemented Bitcoin privacy. Traditional banking provides comprehensive observation: every transaction is recorded, attributed, and reported. The state's OODA loop operates smoothly from observation through action. Private Bitcoin usage, employing techniques examined in Chapter 15, breaks observation. Transactions occur; the state does not see them. The entire decision cycle never begins.

States therefore work aggressively to restore observation. KYC requirements at exchanges attempt to link Bitcoin transactions to identities, restoring the observation that Bitcoin's pseudonymity impairs. Travel rules attempt to extend reporting requirements to cryptocurrency transfers. Blockchain analysis firms sell orientation capabilities, pattern-matching services that attempt to deanonymize transactions. Each effort aims to restore the observation that enables subsequent stages.

### Cost Asymmetry

The OODA framework reveals a fundamental cost asymmetry. Observation infrastructure is expensive: building and maintaining the financial surveillance apparatus requires substantial ongoing investment in reporting systems, analysis capabilities, storage, and personnel. Each stage of the loop consumes resources.

Privacy, by contrast, can be cheap. Generating a cryptographic key costs nothing. Using CoinJoin or Lightning Network adds minimal friction. Running transactions through privacy-preserving infrastructure imposes modest costs on the user while potentially imposing massive costs on the adversary attempting to restore observation.

This asymmetry explains why privacy is strategic. The defender who prevents observation imposes costs far exceeding their own expenditure. The attacker who must overcome privacy protections faces costs that may exceed the value of the intelligence gained. When observation becomes expensive enough, the entire attack cycle becomes uneconomical.

### CBDCs as Observation Infrastructure

Central Bank Digital Currencies, examined in section 10.5, represent an attempt to make observation automatic and inescapable. If all transactions occur through state-controlled infrastructure, the Observe stage becomes trivial: every economic act is visible immediately to the monetary authority. The state no longer needs to compel third-party reporting or analyze incomplete data. Observation is built into the monetary system itself.

CBDCs are not a technical upgrade to existing payment systems. They are a fundamental restructuring of the adversarial relationship between state and citizen. By eliminating the possibility of unobserved transactions, CBDCs would eliminate the most effective point at which privacy breaks the state's decision cycle.

The response, developed in Part V, is to build and use monetary systems where observation is structurally difficult or impossible. Bitcoin's design, whatever its limitations, makes observation harder than traditional banking. Privacy enhancements make it harder still. The goal is not perfect unobservability but raising observation costs beyond what adversaries are willing to pay.

## Chapter Summary

Financial surveillance operates through Rothbard's three intervention types. Autistic intervention directly prohibits privacy tools and behaviors. Binary intervention extracts information and assets from individuals. Triangular intervention, the dominant form, imposes surveillance requirements on private transactions.

The Bank Secrecy Act, KYC requirements, and third-party reporting exemplify triangular intervention. States force private institutions to surveil on their behalf, shifting costs while gathering comprehensive financial intelligence. This intervention cascades: initial requirements reveal gaps necessitating expanded surveillance, which reveals more gaps, producing ever more comprehensive monitoring.

Central Bank Digital Currencies represent the logical endpoint: programmable money combining all three intervention types. Unlike today's system, where citizens hold money substitutes (claims on commercial banks) and only physical cash provides direct access to base money, CBDCs would give citizens digital base money as direct balances at the central bank. This architectural transformation eliminates the commercial bank buffer, establishing an unmediated relationship between state and individual. CBDCs can prohibit transactions directly (autistic), extract data through direct central bank accounts (binary), and impose requirements on private exchanges through the monetary medium itself (triangular). Programmable features enable expiration dates, geographic restrictions, category prohibitions, and identity requirements impossible with traditional money.

All these interventions follow Boyd's OODA loop: Observe, Orient, Decide, Act. Financial surveillance exists to enable observation; analysis transforms observation into orientation; resource allocation determines decision; enforcement constitutes action. Privacy breaks this cycle at the observation stage, preventing all subsequent stages from occurring. The cost asymmetry favors defenders: privacy can be cheap while restoring observation is expensive. This is why privacy is strategic.

Understanding intervention mechanisms clarifies what privacy technologies must resist. Sound money requires properties that resist state control: decentralization, censorship resistance, and transaction privacy. Part V examines implementations; this chapter establishes the threat model.

---

## Footnotes

^1^ Franz Oppenheimer, *The State*, trans. John M. Gitterman (Indianapolis: Bobbs-Merrill, 1914), 15.

^2^ Murray N. Rothbard, *Power and Market: Government and the Economy*, 4th ed. (Auburn, AL: Ludwig von Mises Institute, 2006), chapters 1-2.

^3^ For the evolution of BSA reporting requirements, see U.S. Department of the Treasury, Financial Crimes Enforcement Network, "History of Anti-Money Laundering Laws," available at https://www.fincen.gov/history-anti-money-laundering-laws.

^4^ Rothbard analyzes intervention cascade effects in *Power and Market*, chapter 3, and in Murray N. Rothbard, *Man, Economy, and State*, Scholar's Edition (Auburn, AL: Ludwig von Mises Institute, 2009), chapter 12.

^5^ For economic analysis of CBDCs, see Jörg Guido Hülsmann, *The Ethics of Money Production* (Auburn, AL: Ludwig von Mises Institute, 2008), and for technical analysis, Agustín Carstens (General Manager, BIS), "Digital Currencies and the Future of the Monetary System," speech at the Hoover Institution, January 2021.

^6^ Human Rights Foundation, "CBDC Tracker," available at https://cbdctracker.hrf.org. The tracker monitors CBDC development globally with particular attention to civil liberties implications. Launched in 2023, it is the first monitoring effort focused specifically on the human rights impact of central bank digital currencies. The Foundation notes that dictatorships are leading CBDC deployment, with nearly half the world's population living under autocracies actively developing these systems.
